/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteServerController;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactoryManager;
import com.orientechnologies.orient.server.distributed.impl.task.ODefaultRemoteTaskFactoryV0;
import com.orientechnologies.orient.server.distributed.impl.task.ODefaultRemoteTaskFactoryV1;
import com.orientechnologies.orient.server.distributed.impl.task.ODefaultRemoteTaskFactoryV2;
import java.io.IOException;
import java.util.Collection;

public class ORemoteTaskFactoryManagerImpl
implements ORemoteTaskFactoryManager {
    private final ODistributedServerManager dManager;
    private ORemoteTaskFactory[] factories = new ORemoteTaskFactory[3];

    public ORemoteTaskFactoryManagerImpl(ODistributedServerManager dManager) {
        this.dManager = dManager;
        this.factories[0] = new ODefaultRemoteTaskFactoryV0();
        this.factories[1] = new ODefaultRemoteTaskFactoryV1();
        this.factories[2] = new ODefaultRemoteTaskFactoryV2();
    }

    public ORemoteTaskFactory getFactoryByServerId(int serverId) {
        String remoteNodeName = this.dManager.getNodeNameById(serverId);
        if (remoteNodeName == null) {
            throw new IllegalArgumentException("Invalid serverId " + serverId);
        }
        return this.getFactoryByServerName(remoteNodeName);
    }

    public ORemoteTaskFactory getFactoryByServerNames(Collection<String> serverNames) {
        int minVersion = 2;
        ORemoteTaskFactory factory = this.getFactoryByVersion(minVersion);
        for (String server : serverNames) {
            try {
                ORemoteTaskFactory f = this.getFactoryByServerName(server);
                if (f.getProtocolVersion() >= minVersion) continue;
                factory = f;
                minVersion = f.getProtocolVersion();
            }
            catch (OIOException oIOException) {}
        }
        return factory;
    }

    public ORemoteTaskFactory getFactoryByServerName(String serverName) {
        try {
            ORemoteServerController remoteServer = this.dManager.getRemoteServer(serverName);
            ORemoteTaskFactory factory = this.getFactoryByVersion(remoteServer.getProtocolVersion());
            if (factory == null) {
                throw new IllegalArgumentException("Cannot find a factory for remote task for server " + serverName);
            }
            return factory;
        }
        catch (ODistributedException e) {
            return this.getFactoryByVersion(2);
        }
        catch (IOException e) {
            throw OException.wrapException((OException)new OIOException("Cannot determine protocol version for server " + serverName), (Throwable)e);
        }
    }

    public ORemoteTaskFactory getFactoryByVersion(int version) {
        if (version < 0 || version >= this.factories.length) {
            throw new IllegalArgumentException("Invalid remote task factory version " + version);
        }
        return this.factories[version];
    }
}

