/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import java.util.TimerTask;

public class OStopServerTask
extends OAbstractRemoteTask {
    private static final long serialVersionUID = 1L;
    public static final int FACTORYID = 9;

    public Object execute(ODistributedRequestId requestId, final OServer iServer, final ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        ODistributedServerLog.warn((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Stopping current server...", (Object[])new Object[0]);
        Orient.instance().scheduleTask(new TimerTask(){

            @Override
            public void run() {
                try {
                    iServer.shutdown();
                }
                catch (Exception e) {
                    ODistributedServerLog.error((Object)this, (String)iManager.getLocalNodeName(), (String)OStopServerTask.this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Error on stopping current server", (Throwable)e, (Object[])new Object[0]);
                }
            }
        }, 1L, 0L);
        return true;
    }

    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.NONE;
    }

    public String getName() {
        return "stop_server";
    }

    public int getFactoryId() {
        return 9;
    }

    public boolean isUsingDatabase() {
        return false;
    }
}

