/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OPlaceholder;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import com.orientechnologies.orient.core.tx.OTransactionOptimistic;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedTxContext;
import com.orientechnologies.orient.server.distributed.impl.task.OAbstract2pcTask;
import com.orientechnologies.orient.server.distributed.impl.task.OCreateRecordTask;
import com.orientechnologies.orient.server.distributed.impl.task.OTxTaskResult;
import com.orientechnologies.orient.server.distributed.impl.task.OUpdateRecordTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractRecordReplicatedTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OTxTask
extends OAbstract2pcTask {
    public static final int FACTORYID = 7;
    transient ODistributedTxContext reqContext;

    public Object execute(ODistributedRequestId requestId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        ODistributedServerLog.debug((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Executing transaction db=%s (reqId=%s)...", (Object[])new Object[]{database.getName(), requestId});
        ODatabaseRecordThreadLocal.instance().set(database);
        ODistributedDatabase ddb = iManager.getMessageService().getDatabase(database.getName());
        this.reqContext = ddb.registerTxContext(requestId);
        ODistributedConfiguration dCfg = iManager.getDatabaseConfiguration(database.getName());
        this.result = new OTxTaskResult();
        if (this.tasks.size() == 0) {
            return this.result;
        }
        database.begin();
        try {
            OTransactionOptimistic tx = (OTransactionOptimistic)database.getTransaction();
            for (Object task : this.tasks) {
                String clusterName;
                OCreateRecordTask createRT;
                ORecordId rid;
                if (!(task instanceof OCreateRecordTask) || (rid = (createRT = (OCreateRecordTask)((Object)task)).getRid()) != null && rid.isPersistent() && rid.getRecord() != null) continue;
                int clId = createRT.clusterId > -1 ? createRT.clusterId : (createRT.getRid().isValid() ? createRT.getRid().getClusterId() : -1);
                String string = clusterName = clId > -1 ? database.getClusterNameById(clId) : null;
                if (!dCfg.isServerContainingCluster(iManager.getLocalNodeName(), clusterName)) continue;
                tx.addRecord(createRT.getRecord(), (byte)3, clusterName);
            }
            ArrayList<ORecordId> rids2Lock = new ArrayList<ORecordId>();
            for (OAbstractRecordReplicatedTask task : this.tasks) {
                rids2Lock.add(task.getRid());
            }
            Collections.sort(rids2Lock);
            for (ORecordId rid : rids2Lock) {
                this.reqContext.lock((ORID)rid, this.getRecordLock());
            }
            for (OAbstractRecordReplicatedTask task : this.tasks) {
                Object taskResult;
                if (!task.checkForClusterAvailability(iManager.getLocalNodeName(), dCfg)) {
                    taskResult = "_non_local_cluster";
                } else {
                    task.setLockRecords(false);
                    task.checkRecordExists();
                    taskResult = task.execute(requestId, iServer, iManager, database);
                    this.reqContext.addUndoTask(task.getUndoTask(iManager, requestId, OMultiValue.getSingletonList((Object)iManager.getLocalNodeName())));
                }
                this.result.results.add(taskResult);
            }
            database.commit();
            for (int i = 0; i < this.tasks.size(); ++i) {
                OAbstractRecordReplicatedTask task;
                task = (OAbstractRecordReplicatedTask)this.tasks.get(i);
                if (!(task instanceof OCreateRecordTask)) continue;
                this.reqContext.lock(((OPlaceholder)this.result.results.get(i)).getIdentity(), this.getRecordLock());
            }
        }
        catch (Exception e) {
            ODistributedServerLog.debug((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Rolling back transaction on local server db=%s (reqId=%s error=%s)...", (Object[])new Object[]{database.getName(), requestId, e});
            database.rollback();
            this.reqContext.clearUndo();
            if (!(e instanceof ONeedRetryException || e instanceof OTransactionException || e instanceof ORecordDuplicatedException || e instanceof ORecordNotFoundException)) {
                ODistributedServerLog.info((Object)((Object)this), (String)this.getNodeSource(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on distributed transaction commit", (Throwable)e, (Object[])new Object[0]);
            }
            return e;
        }
        for (int i = 0; i < this.result.results.size(); ++i) {
            Object currentResult = this.result.results.get(i);
            if (currentResult == "_non_local_cluster") continue;
            OAbstractRecordReplicatedTask task = (OAbstractRecordReplicatedTask)this.tasks.get(i);
            if (task instanceof OCreateRecordTask) {
                OCreateRecordTask t = (OCreateRecordTask)task;
                this.result.results.set(i, new OPlaceholder(t.getRecord()));
                continue;
            }
            if (!(task instanceof OUpdateRecordTask)) continue;
            this.result.results.set(i, task.getRecord().getVersion());
        }
        return this.result;
    }

    protected long getRecordLock() {
        return OGlobalConfiguration.DISTRIBUTED_ATOMIC_LOCK_TIMEOUT.getValueAsLong();
    }

    public String getName() {
        return "tx";
    }

    public int getFactoryId() {
        return 7;
    }

    public List<ORecordId> getInvolvedRecords() {
        ArrayList<ORecordId> list = new ArrayList<ORecordId>();
        for (OAbstractRecordReplicatedTask t : this.tasks) {
            if (t.getRid() == null) continue;
            list.add(t.getRid());
        }
        return list;
    }
}

