/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.hazelcast;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ONetworkSimulator {
    private final Map<String, Set<String>> isolated = new HashMap<String, Set<String>>();
    private static final ONetworkSimulator instance = new ONetworkSimulator();

    private ONetworkSimulator() {
    }

    public static ONetworkSimulator getInstance() {
        return instance;
    }

    public synchronized void isolate(String server1, String server2) {
        Set<String> server1Set = this.isolated.get(server1);
        if (server1Set == null) {
            server1Set = new HashSet<String>();
            this.isolated.put(server1, server1Set);
        }
        server1Set.add(server2);
        Set<String> server2Set = this.isolated.get(server2);
        if (server2Set == null) {
            server2Set = new HashSet<String>();
            this.isolated.put(server2, server2Set);
        }
        server2Set.add(server1);
    }

    public synchronized boolean areIsolated(String server1, String server2) {
        Set<String> server1Set = this.isolated.get(server1);
        return server1Set != null && server1Set.contains(server2);
    }

    public synchronized void removeIsolation(String server1, String server2) {
        Set<String> server2Set;
        Set<String> server1Set = this.isolated.get(server1);
        if (server1Set != null) {
            server1Set.remove(server2);
        }
        if ((server2Set = this.isolated.get(server2)) != null) {
            server2Set.remove(server1);
        }
    }

    public synchronized void reset() {
        this.isolated.clear();
    }
}

