/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.wrappers.partition;

import com.tinkerpop.blueprints.CloseableIterable;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.wrappers.partition.PartitionGraph;
import com.tinkerpop.blueprints.util.wrappers.partition.PartitionVertex;
import java.util.Iterator;
import java.util.NoSuchElementException;

class PartitionVertexIterable
implements CloseableIterable<Vertex> {
    private final Iterable<Vertex> iterable;
    private final PartitionGraph graph;

    public PartitionVertexIterable(Iterable<Vertex> iterable, PartitionGraph graph) {
        this.iterable = iterable;
        this.graph = graph;
    }

    @Override
    public Iterator<Vertex> iterator() {
        return new Iterator<Vertex>(){
            private final Iterator<Vertex> itty;
            private PartitionVertex nextVertex;
            {
                this.itty = PartitionVertexIterable.this.iterable.iterator();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                if (null != this.nextVertex) {
                    return true;
                }
                while (this.itty.hasNext()) {
                    Vertex vertex = this.itty.next();
                    if (!PartitionVertexIterable.this.graph.isInPartition(vertex)) continue;
                    this.nextVertex = new PartitionVertex(vertex, PartitionVertexIterable.this.graph);
                    return true;
                }
                return false;
            }

            @Override
            public Vertex next() {
                if (null != this.nextVertex) {
                    PartitionVertex temp = this.nextVertex;
                    this.nextVertex = null;
                    return temp;
                }
                while (this.itty.hasNext()) {
                    Vertex vertex = this.itty.next();
                    if (!PartitionVertexIterable.this.graph.isInPartition(vertex)) continue;
                    return new PartitionVertex(vertex, PartitionVertexIterable.this.graph);
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public void close() {
        if (this.iterable instanceof CloseableIterable) {
            ((CloseableIterable)this.iterable).close();
        }
    }
}

