/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.listener;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;

public abstract class OListenerManger<L> {
    private final Collection<L> listeners;

    public OListenerManger(boolean concurrent) {
        this.listeners = concurrent ? Collections.newSetFromMap(new ConcurrentHashMap()) : new HashSet<L>();
    }

    public void registerListener(L iListener) {
        if (iListener != null) {
            this.listeners.add(iListener);
        }
    }

    public void unregisterListener(L iListener) {
        if (iListener != null) {
            this.listeners.remove(iListener);
        }
    }

    public void resetListeners() {
        this.listeners.clear();
    }

    public Iterable<L> browseListeners() {
        return this.listeners;
    }

    public Iterable<L> getListenersCopy() {
        return new HashSet<L>(this.listeners);
    }
}

