/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.conflict;

import com.orientechnologies.orient.core.conflict.ORecordConflictStrategy;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.exception.OFastConcurrentModificationException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.concurrent.atomic.AtomicInteger;

public class OVersionRecordConflictStrategy
implements ORecordConflictStrategy {
    public static final String NAME = "version";

    @Override
    public byte[] onUpdate(OStorage storage, byte iRecordType, ORecordId rid, int iRecordVersion, byte[] iRecordContent, AtomicInteger iDatabaseVersion) {
        this.checkVersions(rid, iRecordVersion, iDatabaseVersion.get());
        return null;
    }

    @Override
    public String getName() {
        return NAME;
    }

    protected void checkVersions(ORecordId rid, int iRecordVersion, int iDatabaseVersion) {
        if (OFastConcurrentModificationException.enabled()) {
            throw OFastConcurrentModificationException.instance();
        }
        throw new OConcurrentModificationException(rid, iDatabaseVersion, iRecordVersion, 1);
    }
}

