/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.tool.importer;

import com.orientechnologies.orient.core.db.document.ODocumentFieldVisitor;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.db.tool.importer.OConverterData;
import com.orientechnologies.orient.core.db.tool.importer.OImportConvertersFactory;
import com.orientechnologies.orient.core.db.tool.importer.OValuesConverter;
import com.orientechnologies.orient.core.metadata.schema.OType;

public final class OLinksRewriter
implements ODocumentFieldVisitor {
    private OConverterData converterData;

    public OLinksRewriter(OConverterData converterData) {
        this.converterData = converterData;
    }

    @Override
    public Object visitField(OType type, OType linkedType, Object value) {
        OValuesConverter valuesConverter;
        boolean oldAutoConvertValue = false;
        if (value instanceof ORecordLazyMultiValue) {
            ORecordLazyMultiValue multiValue = (ORecordLazyMultiValue)value;
            oldAutoConvertValue = multiValue.isAutoConvertToRecord();
            multiValue.setAutoConvertToRecord(false);
        }
        if ((valuesConverter = OImportConvertersFactory.INSTANCE.getConverter(value, this.converterData)) == null) {
            return value;
        }
        Object newValue = valuesConverter.convert(value);
        if (value instanceof ORecordLazyMultiValue) {
            ORecordLazyMultiValue multiValue = (ORecordLazyMultiValue)value;
            multiValue.setAutoConvertToRecord(oldAutoConvertValue);
        }
        if (newValue == OImportConvertersFactory.BROKEN_LINK) {
            return null;
        }
        return newValue;
    }

    @Override
    public boolean goFurther(OType type, OType linkedType, Object value, Object newValue) {
        return true;
    }

    @Override
    public boolean goDeeper(OType type, OType linkedType, Object value) {
        return true;
    }

    @Override
    public boolean updateMode() {
        return true;
    }
}

