/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.intent;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.object.ODatabaseObject;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.index.OClassIndexManager;
import com.orientechnologies.orient.core.intent.OIntent;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import java.util.HashMap;
import java.util.Map;

public class OIntentMassiveInsert
implements OIntent {
    private boolean previousRetainRecords;
    private boolean previousRetainObjects;
    private boolean previousValidation;
    private boolean previousTxRequiredForSQLGraphOperations;
    private Map<ORecordHook, ORecordHook.HOOK_POSITION> removedHooks;
    private OSecurityUser currentUser;
    private boolean disableValidation = true;
    private boolean disableSecurity = true;
    private boolean disableHooks = true;
    private boolean enableCache = true;

    @Override
    public void begin(ODatabaseDocumentInternal iDatabase) {
        if (this.disableSecurity) {
            this.currentUser = iDatabase.getDatabaseOwner().getUser();
            iDatabase.getDatabaseOwner().setUser(null);
        }
        ODatabaseInternal<?> ownerDb = iDatabase.getDatabaseOwner();
        this.previousTxRequiredForSQLGraphOperations = ownerDb.getStorage().getConfiguration().isTxRequiredForSQLGraphOperations();
        if (this.previousTxRequiredForSQLGraphOperations && !ownerDb.getStorage().isRemote()) {
            ownerDb.getStorage().setProperty("txRequiredForSQLGraphOperations", Boolean.FALSE.toString());
        }
        if (!this.enableCache) {
            ownerDb.getLocalCache().setEnable(this.enableCache);
        }
        if (ownerDb instanceof ODatabaseDocument) {
            this.previousRetainRecords = ((ODatabaseDocument)((Object)ownerDb)).isRetainRecords();
            ((ODatabaseDocument)((Object)ownerDb)).setRetainRecords(false);
            if (this.disableValidation && !iDatabase.getStorage().isRemote()) {
                this.previousValidation = ((ODatabaseDocument)((Object)ownerDb)).isValidationEnabled();
                if (this.previousValidation) {
                    ((ODatabaseDocument)((Object)ownerDb)).setValidationEnabled(false);
                }
            }
        }
        while (ownerDb.getDatabaseOwner() != ownerDb) {
            ownerDb = ownerDb.getDatabaseOwner();
        }
        if (ownerDb instanceof ODatabaseObject) {
            this.previousRetainObjects = ((ODatabaseObject)((Object)ownerDb)).isRetainObjects();
            ((ODatabaseObject)((Object)ownerDb)).setRetainObjects(false);
        }
        if (this.disableHooks) {
            this.removedHooks = new HashMap<ORecordHook, ORecordHook.HOOK_POSITION>();
            HashMap<ORecordHook, ORecordHook.HOOK_POSITION> hooks = new HashMap<ORecordHook, ORecordHook.HOOK_POSITION>(ownerDb.getHooks());
            for (Map.Entry<ORecordHook, ORecordHook.HOOK_POSITION> hook : hooks.entrySet()) {
                if (hook.getKey() instanceof OClassIndexManager) continue;
                this.removedHooks.put(hook.getKey(), hook.getValue());
                ownerDb.unregisterHook(hook.getKey());
            }
        }
    }

    @Override
    public void end(ODatabaseDocumentInternal iDatabase) {
        ODatabaseInternal<?> ownerDb = iDatabase.getDatabaseOwner();
        if (this.disableSecurity && this.currentUser != null) {
            ownerDb.setUser(this.currentUser);
        }
        if (this.previousTxRequiredForSQLGraphOperations && !ownerDb.getStorage().isRemote()) {
            ownerDb.getStorage().setProperty("txRequiredForSQLGraphOperations", Boolean.TRUE.toString());
        }
        if (!this.enableCache) {
            ownerDb.getLocalCache().setEnable(!this.enableCache);
        }
        if (ownerDb instanceof ODatabaseDocument) {
            ((ODatabaseDocument)((Object)ownerDb)).setRetainRecords(this.previousRetainRecords);
            if (this.disableValidation && !iDatabase.getStorage().isRemote()) {
                ((ODatabaseDocument)((Object)ownerDb)).setValidationEnabled(this.previousValidation);
            }
        }
        while (ownerDb.getDatabaseOwner() != ownerDb) {
            ownerDb = ownerDb.getDatabaseOwner();
        }
        if (ownerDb instanceof ODatabaseObject) {
            ((ODatabaseObject)((Object)ownerDb)).setRetainObjects(this.previousRetainObjects);
        }
        if (this.disableHooks && this.removedHooks != null) {
            for (Map.Entry<ORecordHook, ORecordHook.HOOK_POSITION> hook : this.removedHooks.entrySet()) {
                ownerDb.registerHook(hook.getKey(), hook.getValue());
            }
        }
    }

    public boolean isDisableValidation() {
        return this.disableValidation;
    }

    public OIntentMassiveInsert setDisableValidation(boolean disableValidation) {
        this.disableValidation = disableValidation;
        return this;
    }

    public boolean isDisableSecurity() {
        return this.disableSecurity;
    }

    public OIntentMassiveInsert setDisableSecurity(boolean disableSecurity) {
        this.disableSecurity = disableSecurity;
        return this;
    }

    public boolean isDisableHooks() {
        return this.disableHooks;
    }

    public OIntentMassiveInsert setDisableHooks(boolean disableHooks) {
        this.disableHooks = disableHooks;
        return this;
    }

    public OIntentMassiveInsert setEnableCache(boolean enableCache) {
        this.enableCache = enableCache;
        return this;
    }

    @Override
    public OIntent copy() {
        OIntentMassiveInsert copy = new OIntentMassiveInsert();
        copy.previousRetainRecords = this.previousRetainRecords;
        copy.previousRetainObjects = this.previousRetainObjects;
        copy.previousValidation = this.previousValidation;
        copy.disableValidation = this.disableValidation;
        copy.disableSecurity = this.disableSecurity;
        copy.disableHooks = this.disableHooks;
        copy.currentUser = this.currentUser;
        if (this.removedHooks != null) {
            copy.removedHooks = new HashMap<ORecordHook, ORecordHook.HOOK_POSITION>(this.removedHooks);
        }
        return copy;
    }
}

