/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.schema.clusterselection;

import com.orientechnologies.common.factory.OConfigurableStatefulFactory;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OClassLoaderHelper;
import com.orientechnologies.orient.core.metadata.schema.clusterselection.OClusterSelectionStrategy;
import com.orientechnologies.orient.core.metadata.schema.clusterselection.ORoundRobinClusterSelectionStrategy;
import java.lang.reflect.Method;
import java.util.Iterator;

public class OClusterSelectionFactory
extends OConfigurableStatefulFactory<String, OClusterSelectionStrategy> {
    private static ClassLoader orientClassLoader = OClusterSelectionFactory.class.getClassLoader();

    public OClusterSelectionFactory() {
        this.setDefaultClass(ORoundRobinClusterSelectionStrategy.class);
        this.registerStrategy();
    }

    private void registerStrategy() {
        Iterator<OClusterSelectionStrategy> ite = OClassLoaderHelper.lookupProviderWithOrientClassLoader(OClusterSelectionStrategy.class, orientClassLoader);
        while (ite.hasNext()) {
            OClusterSelectionStrategy strategy = ite.next();
            Class<?> clz = strategy.getClass();
            try {
                Method method = clz.getMethod("getName", new Class[0]);
                if (method != null) {
                    String key = (String)method.invoke(clz.newInstance(), new Object[0]);
                    this.register(key, clz);
                    continue;
                }
                OLogManager.instance().error(this, "getName() funciton missing", null, new Object[0]);
            }
            catch (Exception ex) {
                OLogManager.instance().error(this, "failed to register class - " + clz.getName(), ex, new Object[0]);
            }
        }
    }

    public OClusterSelectionStrategy getStrategy(String iStrategy) {
        return (OClusterSelectionStrategy)this.newInstance(iStrategy);
    }
}

