/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandExecutor;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OStatementCache;
import com.orientechnologies.orient.core.sql.query.OSQLAsynchQuery;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class OCommandExecutorToOStatementWrapper
implements OCommandExecutor {
    protected OSQLAsynchQuery<ODocument> request;
    private OCommandContext context;
    private OProgressListener progressListener;
    protected OStatement statement;

    public OCommandExecutorToOStatementWrapper parse(OCommandRequest iCommand) {
        OCommandRequestText textRequest = (OCommandRequestText)iCommand;
        if (iCommand instanceof OSQLAsynchQuery) {
            this.request = (OSQLAsynchQuery)iCommand;
        } else {
            this.request = new OSQLSynchQuery<ODocument>(textRequest.getText());
            if (textRequest.getResultListener() != null) {
                this.request.setResultListener(textRequest.getResultListener());
            }
        }
        String queryText = textRequest.getText();
        this.statement = OStatementCache.get(queryText, OCommandExecutorToOStatementWrapper.getDatabase());
        return this;
    }

    public static ODatabaseDocumentInternal getDatabase() {
        return ODatabaseRecordThreadLocal.instance().get();
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        return this.statement.execute(this.request, this.context, this.progressListener);
    }

    @Override
    public <RET extends OCommandExecutor> RET setProgressListener(OProgressListener progressListener) {
        this.progressListener = progressListener;
        return (RET)this;
    }

    @Override
    public <RET extends OCommandExecutor> RET setLimit(int iLimit) {
        return (RET)this;
    }

    @Override
    public String getFetchPlan() {
        return null;
    }

    @Override
    public Map<Object, Object> getParameters() {
        return null;
    }

    @Override
    public OCommandContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(OCommandContext context) {
        this.context = context;
    }

    @Override
    public boolean isIdempotent() {
        return false;
    }

    @Override
    public Set<String> getInvolvedClusters() {
        return Collections.EMPTY_SET;
    }

    @Override
    public int getSecurityOperationType() {
        return ORole.PERMISSION_READ;
    }

    @Override
    public boolean involveSchema() {
        return false;
    }

    @Override
    public String getSyntax() {
        return "PROFILE STORAGE [ON | OFF]";
    }

    @Override
    public boolean isLocalExecution() {
        return true;
    }

    @Override
    public boolean isCacheable() {
        return false;
    }

    @Override
    public long getDistributedTimeout() {
        return 0L;
    }

    @Override
    public Object mergeResults(Map<String, Object> results) throws Exception {
        return null;
    }
}

