/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.OBinaryField;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerBinary;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEqualityNotNulls;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEquals;

public class OQueryOperatorNotEquals
extends OQueryOperatorEqualityNotNulls {
    private boolean binaryEvaluate = false;

    public OQueryOperatorNotEquals() {
        super("<>", 5, false);
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().getIfDefined();
        if (db != null) {
            this.binaryEvaluate = db.getSerializer().getSupportBinaryEvaluate();
        }
    }

    @Override
    protected boolean evaluateExpression(OIdentifiable iRecord, OSQLFilterCondition iCondition, Object iLeft, Object iRight, OCommandContext iContext) {
        return !OQueryOperatorEquals.equals(iLeft, iRight);
    }

    @Override
    public boolean isSupportingBinaryEvaluate() {
        return this.binaryEvaluate;
    }

    @Override
    public boolean evaluate(OBinaryField iFirstField, OBinaryField iSecondField, OCommandContext iContext) {
        return !ORecordSerializerBinary.INSTANCE.getCurrentSerializer().getComparator().isEqual(iFirstField, iSecondField);
    }

    @Override
    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        return OIndexReuseType.NO_INDEX;
    }

    @Override
    public ORID getBeginRidRange(Object iLeft, Object iRight) {
        return null;
    }

    @Override
    public ORID getEndRidRange(Object iLeft, Object iRight) {
        return null;
    }
}

