/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.parser.OJsonItem;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class OJson
extends SimpleNode {
    protected List<OJsonItem> items = new ArrayList<OJsonItem>();

    public OJson(int id) {
        super(id);
    }

    public OJson(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("{");
        boolean first = true;
        for (OJsonItem item : this.items) {
            if (!first) {
                builder.append(", ");
            }
            item.toString(params, builder);
            first = false;
        }
        builder.append("}");
    }

    public ODocument toDocument(OIdentifiable source, OCommandContext ctx) {
        String className = this.getClassNameForDocument(ctx);
        ODocument doc = className != null ? new ODocument(className) : new ODocument();
        for (OJsonItem item : this.items) {
            String name = item.getLeftValue();
            if (name == null) continue;
            Object value = item.right.value instanceof OJson ? ((OJson)item.right.value).toDocument(source, ctx) : item.right.execute(source, ctx);
            doc.field(name, value);
        }
        return doc;
    }

    public Map<String, Object> toMap(OIdentifiable source, OCommandContext ctx) {
        String className = this.getClassNameForDocument(ctx);
        HashMap<String, Object> doc = new HashMap<String, Object>();
        for (OJsonItem item : this.items) {
            String name = item.getLeftValue();
            if (name == null) continue;
            Object value = item.right.execute(source, ctx);
            doc.put(name, value);
        }
        return doc;
    }

    private String getClassNameForDocument(OCommandContext ctx) {
        for (OJsonItem item : this.items) {
            String left = item.getLeftValue();
            if (!left.toLowerCase(Locale.ENGLISH).equals("@class")) continue;
            return "" + item.right.execute(null, ctx);
        }
        return null;
    }
}

