/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OMatchFilterItem;
import com.orientechnologies.orient.core.sql.parser.OWhereClause;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OMatchFilter
extends SimpleNode {
    protected List<OMatchFilterItem> items = new ArrayList<OMatchFilterItem>();

    public OMatchFilter(int id) {
        super(id);
    }

    public OMatchFilter(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public String getAlias() {
        for (OMatchFilterItem item : this.items) {
            if (item.alias == null) continue;
            return item.alias.getStringValue();
        }
        return null;
    }

    public void setAlias(String alias) {
        boolean found = false;
        for (OMatchFilterItem item : this.items) {
            if (item.alias == null) continue;
            item.alias = new OIdentifier(-1);
            item.alias.setValue(alias);
            found = true;
            break;
        }
        if (!found) {
            OMatchFilterItem newItem = new OMatchFilterItem(-1);
            newItem.alias = new OIdentifier(-1);
            newItem.alias.setValue(alias);
            this.items.add(newItem);
        }
    }

    public OWhereClause getFilter() {
        for (OMatchFilterItem item : this.items) {
            if (item.filter == null) continue;
            return item.filter;
        }
        return null;
    }

    public void setFilter(OWhereClause filter) {
        boolean found = false;
        for (OMatchFilterItem item : this.items) {
            if (item.filter == null) continue;
            item.filter = filter;
            found = true;
            break;
        }
        if (!found) {
            OMatchFilterItem newItem = new OMatchFilterItem(-1);
            newItem.filter = filter;
            this.items.add(newItem);
        }
    }

    public OWhereClause getWhileCondition() {
        for (OMatchFilterItem item : this.items) {
            if (item.whileCondition == null) continue;
            return item.whileCondition;
        }
        return null;
    }

    public String getClassName(OCommandContext context) {
        for (OMatchFilterItem item : this.items) {
            if (item.className == null) continue;
            if (item.className.value instanceof String) {
                return (String)item.className.value;
            }
            if (item.className.value instanceof SimpleNode) {
                StringBuilder builder = new StringBuilder();
                ((SimpleNode)item.className.value).toString(context == null ? null : context.getInputParameters(), builder);
                return builder.toString();
            }
            return item.className.value.toString();
        }
        return null;
    }

    public ORID getRid(OCommandContext ctx) {
        for (OMatchFilterItem item : this.items) {
            if (item.rid == null) continue;
            return new ORecordId(item.rid.cluster.getValue().intValue(), item.rid.position.getValue().longValue());
        }
        return null;
    }

    public Integer getMaxDepth() {
        for (OMatchFilterItem item : this.items) {
            if (item.maxDepth == null) continue;
            return item.maxDepth.value.intValue();
        }
        return null;
    }

    public boolean isOptional() {
        for (OMatchFilterItem item : this.items) {
            if (!Boolean.TRUE.equals(item.optional)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("{");
        boolean first = true;
        for (OMatchFilterItem item : this.items) {
            if (!first) {
                builder.append(", ");
            }
            item.toString(params, builder);
            first = false;
        }
        builder.append("}");
    }
}

