/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.query.OSQLAsynchQuery;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.statistic.OSessionStoragePerformanceStatistic;
import java.util.Map;

public class OProfileStorageStatement
extends OStatement {
    protected boolean on;
    public static final String KEYWORD_PROFILE = "PROFILE";

    public OProfileStorageStatement(int id) {
        super(id);
    }

    public OProfileStorageStatement(OrientSql p, int id) {
        super(p, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(OSQLAsynchQuery<ODocument> request, OCommandContext context, OProgressListener progressListener) {
        try {
            ODatabaseDocumentInternal db = OProfileStorageStatement.getDatabase();
            OStorage storage = db.getStorage();
            if (this.on) {
                ((OAbstractPaginatedStorage)storage).startGatheringPerformanceStatisticForCurrentThread();
                ODocument result = new ODocument();
                result.field("result", "OK");
                request.getResultListener().result(result);
            } else {
                OSessionStoragePerformanceStatistic performanceStatistic = ((OAbstractPaginatedStorage)storage).completeGatheringPerformanceStatisticForCurrentThread();
                if (performanceStatistic != null) {
                    request.getResultListener().result(performanceStatistic.toDocument());
                } else {
                    ODocument result = new ODocument();
                    result.field("result", "Error: profiling of storage was not started.");
                    request.getResultListener().result(result);
                }
            }
            Object object = this.getResult(request);
            return object;
        }
        finally {
            if (request.getResultListener() != null) {
                request.getResultListener().end();
            }
        }
    }

    protected Object getResult(OSQLAsynchQuery<ODocument> request) {
        if (request instanceof OSQLSynchQuery) {
            return ((OSQLSynchQuery)request).getResult();
        }
        return null;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("PROFILE STORAGE ");
        builder.append(this.on ? "ON" : "OFF");
    }
}

