/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.common.collection.OMultiCollectionIterator;
import com.orientechnologies.common.util.OSizeable;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OCompositeIndexDefinition;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OPropertyIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.sql.parser.OAndBlock;
import com.orientechnologies.orient.core.sql.parser.OBinaryCondition;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OEqualsCompareOperator;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OWhereClause
extends SimpleNode {
    protected OBooleanExpression baseExpression;
    protected List<OAndBlock> flattened;

    public OWhereClause(int id) {
        super(id);
    }

    public OWhereClause(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public boolean matchesFilters(OIdentifiable currentRecord, OCommandContext ctx) {
        if (this.baseExpression == null) {
            return true;
        }
        return this.baseExpression.evaluate(currentRecord, ctx);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        if (this.baseExpression == null) {
            return;
        }
        this.baseExpression.toString(params, builder);
    }

    public long estimate(OClass oClass, long threshold, OCommandContext ctx) {
        long count = oClass.count();
        if (count > 1L) {
            count /= 2L;
        }
        if (count < threshold) {
            return count;
        }
        long indexesCount = 0L;
        List<OAndBlock> flattenedConditions = this.flatten();
        Set<OIndex<?>> indexes = oClass.getIndexes();
        for (OAndBlock condition : flattenedConditions) {
            Map<String, Object> conditions = this.getEqualityOperations(condition, ctx);
            long conditionEstimation = Long.MAX_VALUE;
            for (OIndex<?> index : indexes) {
                long newCount;
                List<String> indexedFields = index.getDefinition().getFields();
                int nMatchingKeys = 0;
                for (String indexedField : indexedFields) {
                    if (!conditions.containsKey(indexedField)) break;
                    ++nMatchingKeys;
                }
                if (nMatchingKeys <= 0 || (newCount = this.estimateFromIndex(index, conditions, nMatchingKeys)) >= conditionEstimation) continue;
                conditionEstimation = newCount;
            }
            if (conditionEstimation > count) {
                return count;
            }
            indexesCount += conditionEstimation;
        }
        return Math.min(indexesCount, count);
    }

    private long estimateFromIndex(OIndex index, Map<String, Object> conditions, int nMatchingKeys) {
        if (nMatchingKeys < 1) {
            throw new IllegalArgumentException("Cannot estimate from an index with zero keys");
        }
        OIndexDefinition definition = index.getDefinition();
        List<String> definitionFields = definition.getFields();
        Object key = null;
        if (definition instanceof OPropertyIndexDefinition) {
            key = this.convert(conditions.get(definitionFields.get(0)), definition.getTypes()[0]);
        } else if (definition instanceof OCompositeIndexDefinition) {
            key = new OCompositeKey();
            for (int i = 0; i < nMatchingKeys; ++i) {
                Object keyValue = this.convert(conditions.get(definitionFields.get(i)), definition.getTypes()[i]);
                ((OCompositeKey)key).addKey(keyValue);
            }
        }
        if (key != null) {
            Iterator<OIdentifiable> result = null;
            if (conditions.size() == definitionFields.size()) {
                result = (Iterator<OIdentifiable>)index.get(key);
            } else if (index.supportsOrderedIterations()) {
                result = index.iterateEntriesBetween(key, true, key, true, true);
            }
            if (result instanceof OIdentifiable) {
                return 1L;
            }
            if (result instanceof Collection) {
                return ((Collection)((Object)result)).size();
            }
            if (result instanceof OSizeable) {
                return ((OSizeable)((Object)result)).size();
            }
            if (result instanceof Iterable) {
                result = ((Iterable)((Object)result)).iterator();
            }
            if (result instanceof Iterator) {
                int i = 0;
                while (((Iterator)result).hasNext()) {
                    ((Iterator)result).next();
                    ++i;
                }
                return i;
            }
        }
        return Long.MAX_VALUE;
    }

    public Iterable fetchFromIndexes(OClass oClass, OCommandContext ctx) {
        List<OAndBlock> flattenedConditions = this.flatten();
        if (flattenedConditions == null || flattenedConditions.size() == 0) {
            return null;
        }
        Set<OIndex<?>> indexes = oClass.getIndexes();
        ArrayList bestIndexes = new ArrayList();
        ArrayList<Map<String, Object>> indexConditions = new ArrayList<Map<String, Object>>();
        for (OAndBlock condition : flattenedConditions) {
            Map<String, Object> conditions = this.getEqualityOperations(condition, ctx);
            long conditionEstimation = Long.MAX_VALUE;
            OIndex<?> bestIndex = null;
            Map<String, Object> bestCondition = null;
            for (OIndex<?> index : indexes) {
                long newCount;
                List<String> indexedFields = index.getDefinition().getFields();
                int nMatchingKeys = 0;
                for (String indexedField : indexedFields) {
                    if (!conditions.containsKey(indexedField)) break;
                    ++nMatchingKeys;
                }
                if (nMatchingKeys <= 0 || (newCount = this.estimateFromIndex(index, conditions, nMatchingKeys)) < 0L || newCount > conditionEstimation) continue;
                conditionEstimation = newCount;
                bestIndex = index;
                bestCondition = conditions;
            }
            if (bestIndex == null) {
                return null;
            }
            bestIndexes.add(bestIndex);
            indexConditions.add(bestCondition);
        }
        OMultiCollectionIterator result = new OMultiCollectionIterator();
        for (int i = 0; i < bestIndexes.size(); ++i) {
            OIndex index = (OIndex)bestIndexes.get(i);
            Map condition = (Map)indexConditions.get(i);
            result.add(this.fetchFromIndex(index, (Map)indexConditions.get(i)));
        }
        return result;
    }

    private Iterable fetchFromIndex(OIndex index, Map<String, Object> conditions) {
        OIndexDefinition definition = index.getDefinition();
        List<String> definitionFields = definition.getFields();
        Object key = null;
        if (definition instanceof OPropertyIndexDefinition) {
            key = this.convert(conditions.get(definitionFields.get(0)), definition.getTypes()[0]);
        } else if (definition instanceof OCompositeIndexDefinition) {
            String keyName;
            key = new OCompositeKey();
            for (int i = 0; i < definitionFields.size() && conditions.containsKey(keyName = definitionFields.get(i)); ++i) {
                Object keyValue = this.convert(conditions.get(keyName), definition.getTypes()[i]);
                ((OCompositeKey)key).addKey(conditions.get(keyName));
            }
        }
        if (key != null) {
            final Object result = index.get(key);
            if (result == null) {
                return Collections.EMPTY_LIST;
            }
            if (result instanceof Iterable) {
                return (Iterable)result;
            }
            if (result instanceof Iterator) {
                return new Iterable(){

                    public Iterator iterator() {
                        return (Iterator)result;
                    }
                };
            }
            return Collections.singleton(result);
        }
        return null;
    }

    private Object convert(Object o, OType oType) {
        return OType.convert(o, oType.getDefaultJavaType());
    }

    private Map<String, Object> getEqualityOperations(OAndBlock condition, OCommandContext ctx) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (OBooleanExpression expression : condition.subBlocks) {
            if (!(expression instanceof OBinaryCondition)) continue;
            OBinaryCondition b = (OBinaryCondition)expression;
            if (!(b.operator instanceof OEqualsCompareOperator) || !b.left.isBaseIdentifier() || !b.right.isEarlyCalculated()) continue;
            result.put(b.left.toString(), b.right.execute(null, ctx));
        }
        return result;
    }

    public List<OAndBlock> flatten() {
        if (this.baseExpression == null) {
            return Collections.EMPTY_LIST;
        }
        if (this.flattened == null) {
            this.flattened = this.baseExpression.flatten();
        }
        return this.flattened;
    }

    public List<OBinaryCondition> getIndexedFunctionConditions(OClass iSchemaClass, ODatabaseDocumentInternal database) {
        if (this.baseExpression == null) {
            return null;
        }
        return this.baseExpression.getIndexedFunctionConditions(iSchemaClass, database);
    }
}

