/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class OClusterEntryIterator
implements Iterator<OPhysicalPosition> {
    private final OCluster cluster;
    private final long min;
    private OPhysicalPosition[] positionsToProcess;
    private int positionsIndex;

    public OClusterEntryIterator(OCluster iCluster) {
        this.cluster = iCluster;
        try {
            this.min = this.cluster.getFirstPosition();
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Exception during iterator creation", ioe);
        }
        this.positionsToProcess = null;
        this.positionsIndex = -1;
    }

    @Override
    public boolean hasNext() {
        if (this.min == -1L) {
            return false;
        }
        if (this.positionsToProcess == null) {
            return true;
        }
        return this.positionsToProcess.length != 0;
    }

    @Override
    public OPhysicalPosition next() {
        try {
            if (this.positionsIndex == -1) {
                this.positionsToProcess = this.cluster.ceilingPositions(new OPhysicalPosition(this.min));
                this.positionsIndex = 0;
            }
            if (this.positionsToProcess.length == 0) {
                throw new NoSuchElementException();
            }
            OPhysicalPosition result = this.positionsToProcess[this.positionsIndex];
            ++this.positionsIndex;
            if (this.positionsIndex >= this.positionsToProcess.length) {
                this.positionsToProcess = this.cluster.higherPositions(this.positionsToProcess[this.positionsToProcess.length - 1]);
                this.positionsIndex = 0;
            }
            return result;
        }
        catch (IOException e) {
            throw OException.wrapException(new ODatabaseException("Cannot read next record of cluster"), e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }
}

