/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;

public class OLuceneMapEntryIterator<K, V>
implements Iterator<Map.Entry<K, V>> {
    private final OIndexDefinition definition;
    private final IndexReader reader;
    private int currentIdx;

    public OLuceneMapEntryIterator(IndexReader reader, OIndexDefinition definition) {
        this.reader = reader;
        this.definition = definition;
        this.currentIdx = 0;
    }

    @Override
    public boolean hasNext() {
        return this.currentIdx < this.reader.maxDoc();
    }

    @Override
    public Map.Entry<K, V> next() {
        try {
            Document doc = this.reader.document(this.currentIdx);
            String val = "";
            if (this.definition.getFields().size() > 0) {
                for (String field : this.definition.getFields()) {
                    val = val + doc.get(field);
                }
            } else {
                val = doc.get("KEY");
            }
            final String finalVal = val;
            final ORecordId id = new ORecordId(doc.get("RID"));
            ++this.currentIdx;
            return new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return finalVal;
                }

                @Override
                public V getValue() {
                    return id;
                }

                @Override
                public V setValue(V value) {
                    return null;
                }
            };
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on iterating Lucene result", (Throwable)e, new Object[0]);
            return null;
        }
    }

    @Override
    public void remove() {
    }
}

