/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.builder;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.lucene.parser.OLuceneMultiFieldQueryParser;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.Query;

public class OLuceneQueryBuilder {
    private final boolean allowLeadingWildcard;
    private final boolean lowercaseExpandedTerms;

    public OLuceneQueryBuilder(ODocument metadata) {
        Boolean allowLeadingWildcard = false;
        if (metadata.containsField("allowLeadingWildcard")) {
            allowLeadingWildcard = (Boolean)metadata.field("allowLeadingWildcard");
        }
        Boolean lowercaseExpandedTerms = true;
        if (metadata.containsField("lowercaseExpandedTerms")) {
            lowercaseExpandedTerms = (Boolean)metadata.field("lowercaseExpandedTerms");
        }
        this.allowLeadingWildcard = allowLeadingWildcard;
        this.lowercaseExpandedTerms = lowercaseExpandedTerms;
    }

    public OLuceneQueryBuilder(boolean allowLeadingWildcard, boolean lowercaseExpandedTerms) {
        this.allowLeadingWildcard = allowLeadingWildcard;
        this.lowercaseExpandedTerms = lowercaseExpandedTerms;
        OLogManager.instance().info((Object)this, "allowLeadingWildcard::  " + allowLeadingWildcard, new Object[0]);
    }

    public Query query(OIndexDefinition index, Object key, Analyzer analyzer) throws com.orientechnologies.orient.core.sql.parser.ParseException {
        String query = "";
        if (key instanceof OCompositeKey) {
            Object params = ((OCompositeKey)key).getKeys().get(0);
            if (params instanceof Map) {
                Object q = ((Map)params).get("q");
                if (q != null) {
                    query = q.toString();
                }
            } else {
                query = params.toString();
            }
        } else {
            query = key.toString();
        }
        return this.getQueryParser(index, query, analyzer);
    }

    protected Query getQueryParser(OIndexDefinition index, String key, Analyzer analyzer) throws com.orientechnologies.orient.core.sql.parser.ParseException {
        int i;
        String[] fields;
        if (index.isAutomatic()) {
            fields = index.getFields().toArray(new String[index.getFields().size()]);
        } else {
            int length = index.getTypes().length;
            fields = new String[length];
            for (i = 0; i < length; ++i) {
                fields[i] = "k" + i;
            }
        }
        HashMap<String, OType> types = new HashMap<String, OType>();
        for (i = 0; i < fields.length; ++i) {
            String field = fields[i];
            types.put(field, index.getTypes()[i]);
        }
        OLuceneMultiFieldQueryParser queryParser = new OLuceneMultiFieldQueryParser(types, fields, analyzer);
        queryParser.setAllowLeadingWildcard(this.allowLeadingWildcard);
        queryParser.setLowercaseExpandedTerms(this.lowercaseExpandedTerms);
        try {
            return queryParser.parse(key);
        }
        catch (ParseException e) {
            OLogManager.instance().error((Object)this, "Exception is suppressed, original exception is ", (Throwable)e, new Object[0]);
            throw new com.orientechnologies.orient.core.sql.parser.ParseException(e.getMessage());
        }
    }
}

