/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.collections;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.lucene.collections.OLuceneAbstractResultSet;
import com.orientechnologies.lucene.engine.OLuceneIndexEngine;
import com.orientechnologies.lucene.engine.OLuceneIndexEngineAbstract;
import com.orientechnologies.lucene.query.OLuceneQueryContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.OContextualRecordId;
import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;

public class OLuceneTxResultSet
extends OLuceneAbstractResultSet {
    private final String indexName;
    protected int deletedMatchCount = this.calculateDeletedMatch();

    public OLuceneTxResultSet(OLuceneIndexEngine manager, OLuceneQueryContext queryContext) {
        super(manager, queryContext);
        this.indexName = manager.indexName();
    }

    private int calculateDeletedMatch() {
        return (int)this.queryContext.changes().deletedDocs(this.query, this.queryContext.filter);
    }

    @Override
    public int size() {
        return Math.max(0, this.topDocs.totalHits - this.deletedMatchCount);
    }

    @Override
    public Iterator<OIdentifiable> iterator() {
        return new OLuceneResultSetIteratorTx();
    }

    private class OLuceneResultSetIteratorTx
    implements Iterator<OIdentifiable> {
        private ScoreDoc[] array;
        private int index;
        private int localIndex;
        private int totalHits;

        public OLuceneResultSetIteratorTx() {
            this.totalHits = OLuceneTxResultSet.this.topDocs.totalHits;
            this.index = 0;
            this.localIndex = 0;
            this.array = OLuceneTxResultSet.this.topDocs.scoreDocs;
            OLuceneIndexEngineAbstract.sendTotalHits(OLuceneTxResultSet.this.indexName, OLuceneTxResultSet.this.queryContext.context, OLuceneTxResultSet.this.topDocs.totalHits - OLuceneTxResultSet.this.deletedMatchCount);
        }

        @Override
        public boolean hasNext() {
            return this.index < this.totalHits - OLuceneTxResultSet.this.deletedMatchCount;
        }

        @Override
        public OIdentifiable next() {
            ScoreDoc scoreDoc;
            Document doc;
            OContextualRecordId res;
            while (this.isToSkip(res = this.toRecordId(doc = this.toDocument(scoreDoc = this.fetchNext()), scoreDoc), doc)) {
            }
            ++this.index;
            return res;
        }

        protected ScoreDoc fetchNext() {
            if (this.localIndex == this.array.length) {
                this.localIndex = 0;
                this.fetchMoreResult();
            }
            ScoreDoc score = this.array[this.localIndex++];
            return score;
        }

        private Document toDocument(ScoreDoc score) {
            Document ret = null;
            try {
                ret = OLuceneTxResultSet.this.queryContext.getSearcher().doc(score.doc);
            }
            catch (IOException e) {
                OLogManager.instance().error((Object)this, "Error during conversion to document", (Throwable)e, new Object[0]);
            }
            return ret;
        }

        private OContextualRecordId toRecordId(Document doc, ScoreDoc score) {
            String rId = doc.get("RID");
            OContextualRecordId res = new OContextualRecordId(rId);
            OLuceneTxResultSet.this.engine.onRecordAddedToResultSet(OLuceneTxResultSet.this.queryContext, res, doc, score);
            return res;
        }

        private boolean isToSkip(OContextualRecordId res, Document doc) {
            return this.isDeleted((OIdentifiable)res, doc) || this.isUpdatedDiskMatch((OIdentifiable)res, doc);
        }

        private void fetchMoreResult() {
            TopDocs topDocs = null;
            try {
                switch (OLuceneTxResultSet.this.queryContext.cfg) {
                    case NO_FILTER_NO_SORT: {
                        topDocs = OLuceneTxResultSet.this.queryContext.getSearcher().searchAfter(this.array[this.array.length - 1], OLuceneTxResultSet.this.query, OLuceneTxResultSet.this.pageSize.intValue());
                        break;
                    }
                    case FILTER_SORT: {
                        topDocs = OLuceneTxResultSet.this.queryContext.getSearcher().searchAfter(this.array[this.array.length - 1], OLuceneTxResultSet.this.query, OLuceneTxResultSet.this.queryContext.filter, OLuceneTxResultSet.this.pageSize.intValue(), OLuceneTxResultSet.this.queryContext.sort);
                        break;
                    }
                    case FILTER: {
                        topDocs = OLuceneTxResultSet.this.queryContext.getSearcher().searchAfter(this.array[this.array.length - 1], OLuceneTxResultSet.this.query, OLuceneTxResultSet.this.queryContext.filter, OLuceneTxResultSet.this.pageSize.intValue());
                        break;
                    }
                    case SORT: {
                        topDocs = OLuceneTxResultSet.this.queryContext.getSearcher().searchAfter(this.array[this.array.length - 1], OLuceneTxResultSet.this.query, OLuceneTxResultSet.this.pageSize.intValue(), OLuceneTxResultSet.this.queryContext.sort);
                    }
                }
                this.array = topDocs.scoreDocs;
            }
            catch (IOException e) {
                OLogManager.instance().error((Object)this, "Error on fetching document by query '%s' to Lucene index", (Throwable)e, new Object[]{OLuceneTxResultSet.this.query});
            }
        }

        private boolean isDeleted(OIdentifiable value, Document doc) {
            return OLuceneTxResultSet.this.queryContext.changes().isDeleted(doc, null, value);
        }

        private boolean isUpdatedDiskMatch(OIdentifiable value, Document doc) {
            return this.isUpdated(value) && !this.isTempMatch(doc);
        }

        private boolean isUpdated(OIdentifiable value) {
            return OLuceneTxResultSet.this.queryContext.changes().isUpdated(null, null, value);
        }

        private boolean isTempMatch(Document doc) {
            return doc.get("_tmp_rid") != null;
        }

        @Override
        public void remove() {
        }
    }
}

