/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.engine;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.lucene.OLuceneIndexType;
import com.orientechnologies.lucene.builder.OLuceneDocumentBuilder;
import com.orientechnologies.lucene.builder.OLuceneQueryBuilder;
import com.orientechnologies.lucene.collections.OLuceneCompositeKey;
import com.orientechnologies.lucene.collections.OLuceneResultSet;
import com.orientechnologies.lucene.collections.OLuceneResultSetFactory;
import com.orientechnologies.lucene.engine.OLuceneFacetManager;
import com.orientechnologies.lucene.engine.OLuceneIndexEngineAbstract;
import com.orientechnologies.lucene.engine.OLuceneIndexWriterFactory;
import com.orientechnologies.lucene.query.OLuceneQueryContext;
import com.orientechnologies.lucene.tx.OLuceneTxChanges;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.OContextualRecordId;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexEngineException;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.parser.ParseException;
import com.orientechnologies.orient.core.storage.OStorage;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.store.Directory;

public class OLuceneFullTextIndexEngine
extends OLuceneIndexEngineAbstract {
    protected OLuceneFacetManager facetManager;
    private OLuceneDocumentBuilder builder;
    private OLuceneQueryBuilder queryBuilder;

    public OLuceneFullTextIndexEngine(OStorage storage, String idxName) {
        super(storage, idxName);
    }

    @Override
    public IndexWriter openIndexWriter(Directory directory) throws IOException {
        return this.createIndexWriter(directory);
    }

    @Override
    public void init(String indexName, String indexType, OIndexDefinition indexDefinition, boolean isAutomatic, ODocument metadata) {
        super.init(indexName, indexType, indexDefinition, isAutomatic, metadata);
        this.queryBuilder = new OLuceneQueryBuilder(metadata);
        this.builder = new OLuceneDocumentBuilder();
    }

    @Override
    public IndexWriter createIndexWriter(Directory directory) throws IOException {
        OLuceneIndexWriterFactory fc = new OLuceneIndexWriterFactory();
        this.facetManager = new OLuceneFacetManager(this.storage, this, this.metadata);
        OLogManager.instance().debug((Object)this, "Creating Lucene index in '%s'...", new Object[]{directory});
        return fc.createIndexWriter(directory, this.metadata, this.indexAnalyzer());
    }

    @Override
    public void delete() {
        super.delete();
        if (this.facetManager != null) {
            this.facetManager.delete();
        }
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public void onRecordAddedToResultSet(OLuceneQueryContext queryContext, OContextualRecordId recordId, Document ret, final ScoreDoc score) {
        this.updateLastAccess();
        this.openIfClosed();
        recordId.setContext((Map)new HashMap<String, Object>(){
            {
                this.put("score", Float.valueOf(score.score));
            }
        });
    }

    public boolean contains(Object key) {
        return false;
    }

    public boolean remove(Object key) {
        return false;
    }

    public Object get(Object key) {
        return this.getInTx(key, null);
    }

    public void put(Object key, Object value) {
        this.updateLastAccess();
        this.openIfClosed();
        Collection container = (Collection)value;
        for (OIdentifiable oIdentifiable : container) {
            Document doc = this.index.isAutomatic() ? this.buildDocument(key, oIdentifiable) : this.putInManualIndex(key, oIdentifiable);
            if (this.facetManager.supportsFacets().booleanValue()) {
                try {
                    this.addDocument(this.facetManager.buildDocument(doc));
                    this.facetManager.commit();
                }
                catch (IOException e) {
                    OLogManager.instance().error((Object)this, "Error while updating facets", (Throwable)e, new Object[0]);
                }
            } else {
                this.addDocument(doc);
            }
            if (this.index.isAutomatic()) continue;
            this.flush();
        }
    }

    public boolean validatedPut(Object key, OIdentifiable value, OIndexEngine.Validator<Object, OIdentifiable> validator) {
        throw new UnsupportedOperationException("Validated put is not supported by OLuceneFullTextIndexEngine");
    }

    public Object getFirstKey() {
        return null;
    }

    public Object getLastKey() {
        return null;
    }

    public OIndexCursor iterateEntriesBetween(Object rangeFrom, boolean fromInclusive, Object rangeTo, boolean toInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) {
        return new LuceneIndexCursor((OLuceneResultSet)this.get(rangeFrom), rangeFrom);
    }

    private Set<OIdentifiable> getResults(Query query, OCommandContext context, Object key, OLuceneTxChanges changes) {
        try {
            IndexSearcher searcher = this.searcher();
            OLuceneQueryContext queryContext = new OLuceneQueryContext(context, searcher, query).setChanges(changes);
            if (this.facetManager.supportsFacets().booleanValue()) {
                this.facetManager.addFacetContext(queryContext, key);
            }
            return OLuceneResultSetFactory.INSTANCE.create(this, queryContext);
        }
        catch (IOException e) {
            throw OIOException.wrapException((OException)new OIndexException("Error reading from Lucene index"), (Throwable)e);
        }
    }

    public OIndexCursor iterateEntriesMajor(Object fromKey, boolean isInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) {
        return null;
    }

    public OIndexCursor iterateEntriesMinor(Object toKey, boolean isInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) {
        return null;
    }

    public boolean hasRangeQuerySupport() {
        return false;
    }

    @Override
    public Document buildDocument(Object key, OIdentifiable value) {
        if (this.index.isAutomatic()) {
            return this.builder.build(this.index, key, value, this.collectionFields, this.metadata);
        }
        return this.putInManualIndex(key, value);
    }

    private Document putInManualIndex(Object key, OIdentifiable oIdentifiable) {
        Document doc = new Document();
        doc.add((IndexableField)OLuceneIndexType.createField("RID", oIdentifiable.getIdentity().toString(), Field.Store.YES));
        if (key instanceof OCompositeKey) {
            List keys = ((OCompositeKey)key).getKeys();
            int k = 0;
            for (Object o : keys) {
                doc.add((IndexableField)OLuceneIndexType.createField("k" + k, o, Field.Store.NO));
                ++k;
            }
        } else if (key instanceof Collection) {
            Collection keys = (Collection)key;
            int k = 0;
            for (Object o : keys) {
                doc.add((IndexableField)OLuceneIndexType.createField("k" + k, o, Field.Store.NO));
                ++k;
            }
        } else {
            doc.add((IndexableField)OLuceneIndexType.createField("k0", key, Field.Store.NO));
        }
        return doc;
    }

    @Override
    public Query buildQuery(Object query) {
        try {
            return this.queryBuilder.query(this.index, query, this.queryAnalyzer());
        }
        catch (ParseException e) {
            throw OException.wrapException((OException)new OIndexEngineException("Error parsing query"), (Throwable)e);
        }
    }

    @Override
    public Object getInTx(Object key, OLuceneTxChanges changes) {
        this.updateLastAccess();
        this.openIfClosed();
        try {
            Query q = this.queryBuilder.query(this.index, key, this.queryAnalyzer());
            OCommandContext context = null;
            if (key instanceof OLuceneCompositeKey) {
                context = ((OLuceneCompositeKey)((Object)key)).getContext();
            }
            return this.getResults(q, context, key, changes);
        }
        catch (ParseException e) {
            throw OException.wrapException((OException)new OIndexEngineException("Error parsing lucene query"), (Throwable)e);
        }
    }

    public class LuceneIndexCursor
    implements OIndexCursor {
        private final Object key;
        private OLuceneResultSet resultSet;
        private Iterator<OIdentifiable> iterator;

        public LuceneIndexCursor(OLuceneResultSet resultSet, Object key) {
            this.resultSet = resultSet;
            this.iterator = resultSet.iterator();
            this.key = key;
        }

        public Map.Entry<Object, OIdentifiable> nextEntry() {
            if (this.iterator.hasNext()) {
                final OIdentifiable next = this.iterator.next();
                return new Map.Entry<Object, OIdentifiable>(){

                    @Override
                    public Object getKey() {
                        return LuceneIndexCursor.this.key;
                    }

                    @Override
                    public OIdentifiable getValue() {
                        return next;
                    }

                    @Override
                    public OIdentifiable setValue(OIdentifiable value) {
                        return null;
                    }
                };
            }
            return null;
        }

        public Set<OIdentifiable> toValues() {
            return null;
        }

        public Set<Map.Entry<Object, OIdentifiable>> toEntries() {
            return null;
        }

        public Set<Object> toKeys() {
            return null;
        }

        public void setPrefetchSize(int prefetchSize) {
        }

        public boolean hasNext() {
            return false;
        }

        public OIdentifiable next() {
            return null;
        }

        public void remove() {
        }
    }
}

