/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.parser;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.lucene.builder.OLuceneDateTools;
import com.orientechnologies.orient.core.metadata.schema.OType;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;

public class OLuceneMultiFieldQueryParser
extends MultiFieldQueryParser {
    private final Map<String, OType> types;

    public OLuceneMultiFieldQueryParser(Map<String, OType> types, String[] fields, Analyzer analyzer, Map<String, Float> boosts) {
        super(fields, analyzer, boosts);
        this.types = types;
    }

    public OLuceneMultiFieldQueryParser(Map<String, OType> types, String[] fields, Analyzer analyzer) {
        super(fields, analyzer);
        this.types = types;
    }

    protected Query getFieldQuery(String field, String queryText, int slop) throws ParseException {
        Query query = this.getQuery(field, queryText, queryText, true, true);
        if (query != null) {
            return query;
        }
        return super.getFieldQuery(field, queryText, slop);
    }

    protected Query getFieldQuery(String field, String queryText, boolean quoted) throws ParseException {
        Query query = this.getQuery(field, queryText, queryText, true, true);
        if (query != null) {
            return query;
        }
        return super.getFieldQuery(field, queryText, quoted);
    }

    protected Query getRangeQuery(String field, String part1, String part2, boolean startInclusive, boolean endInclusive) throws ParseException {
        Query query = this.getQuery(field, part1, part2, startInclusive, endInclusive);
        if (query != null) {
            return query;
        }
        return super.getRangeQuery(field, part1, part2, startInclusive, endInclusive);
    }

    private Query getQuery(String field, String part1, String part2, boolean startInclusive, boolean endInclusive) throws ParseException {
        if (this.types.containsKey(field)) {
            switch (this.types.get(field)) {
                case LONG: {
                    return NumericRangeQuery.newLongRange((String)field, (Long)Long.parseLong(part1), (Long)Long.parseLong(part2), (boolean)startInclusive, (boolean)endInclusive);
                }
                case INTEGER: {
                    return NumericRangeQuery.newIntRange((String)field, (Integer)Integer.parseInt(part1), (Integer)Integer.parseInt(part2), (boolean)startInclusive, (boolean)endInclusive);
                }
                case FLOAT: {
                    return NumericRangeQuery.newFloatRange((String)field, (Float)Float.valueOf(Float.parseFloat(part1)), (Float)Float.valueOf(Float.parseFloat(part2)), (boolean)startInclusive, (boolean)endInclusive);
                }
                case DOUBLE: {
                    return NumericRangeQuery.newDoubleRange((String)field, (Double)Double.parseDouble(part1), (Double)Double.parseDouble(part2), (boolean)startInclusive, (boolean)endInclusive);
                }
                case DATE: 
                case DATETIME: {
                    try {
                        return NumericRangeQuery.newLongRange((String)field, (Long)OLuceneDateTools.stringToTime(part1), (Long)OLuceneDateTools.stringToTime(part2), (boolean)startInclusive, (boolean)endInclusive);
                    }
                    catch (java.text.ParseException e) {
                        OLogManager.instance().error((Object)this, "Exception is suppressed, original exception is ", (Throwable)e, new Object[0]);
                        throw new ParseException(e.getMessage());
                    }
                }
            }
        }
        return null;
    }
}

