/*
 * Decompiled with CFR 0.152.
 */
package com.jezhumble.javasysmon;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileUtils {
    private static final Pattern PROC_DIR_PATTERN = Pattern.compile("([\\d]*)");
    private static final FilenameFilter PROCESS_DIRECTORY_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File file, String string) {
            File file2 = new File(file, string);
            return file2.isDirectory() && PROC_DIR_PATTERN.matcher(string).matches();
        }
    };

    public String[] pidsFromProcFilesystem() {
        return new File("/proc").list(PROCESS_DIRECTORY_FILTER);
    }

    public String slurp(String string) throws IOException {
        return this.slurpFromInputStream(new FileInputStream(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] slurpToByteArray(String string) throws IOException {
        File file = new File(string);
        byte[] byArray = new byte[(int)file.length()];
        try (FileInputStream fileInputStream = null;){
            fileInputStream = new FileInputStream(file);
            ((InputStream)fileInputStream).read(byArray);
            byte[] byArray2 = byArray;
            return byArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String slurpFromInputStream(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            while ((string = bufferedReader.readLine()) != null) {
                stringWriter.write(string);
                stringWriter.write(10);
            }
        }
        finally {
            inputStream.close();
        }
        return stringWriter.toString();
    }

    public String runRegexOnFile(Pattern pattern, String string) {
        try {
            String string2 = this.slurp(string);
            Matcher matcher = pattern.matcher(string2);
            matcher.find();
            String string3 = matcher.group(1);
            if (string3 != null && string3.length() > 0) {
                return string3;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

