/*
 * Decompiled with CFR 0.152.
 */
package com.jezhumble.javasysmon;

import com.jezhumble.javasysmon.CpuTimes;
import com.jezhumble.javasysmon.LinuxMonitor;
import com.jezhumble.javasysmon.MacOsXMonitor;
import com.jezhumble.javasysmon.MemoryStats;
import com.jezhumble.javasysmon.Monitor;
import com.jezhumble.javasysmon.NullMonitor;
import com.jezhumble.javasysmon.OsProcess;
import com.jezhumble.javasysmon.ProcessInfo;
import com.jezhumble.javasysmon.ProcessVisitor;
import com.jezhumble.javasysmon.SolarisMonitor;
import com.jezhumble.javasysmon.WindowsMonitor;
import java.util.ArrayList;

public class JavaSysMon
implements Monitor {
    private static Monitor monitor = null;
    private static ArrayList supported = new ArrayList();

    public static void setMonitor(Monitor monitor) {
        if (JavaSysMon.monitor == null || JavaSysMon.monitor instanceof NullMonitor) {
            JavaSysMon.monitor = monitor;
        }
    }

    static void addSupportedConfig(String string) {
        supported.add(string);
    }

    public static void main(String[] stringArray) throws Exception {
        if (monitor instanceof NullMonitor) {
            System.err.println("Couldn't find an implementation for OS: " + System.getProperty("os.name"));
            System.err.println("Supported configurations:");
            for (String string : supported) {
                System.err.println(string);
            }
        } else {
            if (stringArray.length == 1) {
                System.out.println("Attempting to kill process id " + stringArray[0]);
                monitor.killProcess(Integer.parseInt(stringArray[0]));
            }
            CpuTimes cpuTimes = monitor.cpuTimes();
            System.out.println("OS name: " + monitor.osName() + "  Uptime: " + JavaSysMon.secsInDaysAndHours(monitor.uptimeInSeconds()) + "  Current PID: " + monitor.currentPid());
            System.out.println("Number of CPUs: " + monitor.numCpus() + "  CPU frequency: " + monitor.cpuFrequencyInHz() / 1000000L + " MHz");
            System.out.println("RAM " + monitor.physical() + "  SWAP " + monitor.swap());
            System.out.println("Sampling CPU usage...");
            Thread.sleep(500L);
            System.out.println("CPU Usage: " + monitor.cpuTimes().getCpuUsage(cpuTimes));
            System.out.println("\n" + ProcessInfo.header());
            ProcessInfo[] processInfoArray = monitor.processTable();
            for (int i = 0; i < processInfoArray.length; ++i) {
                System.out.println(processInfoArray[i].toString());
            }
        }
    }

    public boolean supportedPlatform() {
        return !(monitor instanceof NullMonitor);
    }

    private static String secsInDaysAndHours(long l) {
        long l2 = l / 86400L;
        long l3 = l / 3600L - l2 * 24L;
        return l2 + " days " + l3 + " hours";
    }

    @Override
    public String osName() {
        return monitor.osName();
    }

    @Override
    public int numCpus() {
        return monitor.numCpus();
    }

    @Override
    public long cpuFrequencyInHz() {
        return monitor.cpuFrequencyInHz();
    }

    @Override
    public long uptimeInSeconds() {
        return monitor.uptimeInSeconds();
    }

    @Override
    public int currentPid() {
        return monitor.currentPid();
    }

    @Override
    public CpuTimes cpuTimes() {
        return monitor.cpuTimes();
    }

    @Override
    public MemoryStats physical() {
        return monitor.physical();
    }

    @Override
    public MemoryStats swap() {
        return monitor.swap();
    }

    @Override
    public ProcessInfo[] processTable() {
        return monitor.processTable();
    }

    public OsProcess processTree() {
        return OsProcess.createTree(monitor.processTable());
    }

    @Override
    public void killProcess(int n) {
        monitor.killProcess(n);
    }

    public void visitProcessTree(int n, ProcessVisitor processVisitor) {
        OsProcess osProcess = this.processTree().find(n);
        if (osProcess != null) {
            osProcess.accept(processVisitor, 0);
        }
    }

    public void killProcessTree(final int n, final boolean bl) {
        this.visitProcessTree(n, new ProcessVisitor(){

            @Override
            public boolean visit(OsProcess osProcess, int n2) {
                return !bl || n != osProcess.processInfo().getPid();
            }
        });
    }

    public void infanticide() {
        this.killProcessTree(this.currentPid(), true);
    }

    static {
        new MacOsXMonitor();
        new LinuxMonitor();
        new WindowsMonitor();
        new SolarisMonitor();
        new NullMonitor();
    }
}

