/*
 * Decompiled with CFR 0.152.
 */
package com.jezhumble.javasysmon;

import com.jezhumble.javasysmon.CpuTimes;
import com.jezhumble.javasysmon.FileUtils;
import com.jezhumble.javasysmon.JavaSysMon;
import com.jezhumble.javasysmon.LinuxProcessInfoParser;
import com.jezhumble.javasysmon.MemoryStats;
import com.jezhumble.javasysmon.Monitor;
import com.jezhumble.javasysmon.ParseException;
import com.jezhumble.javasysmon.ProcessInfo;
import com.jezhumble.javasysmon.UnixPasswdParser;
import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class LinuxMonitor
implements Monitor {
    private static final Logger LOG = Logger.getLogger(LinuxMonitor.class.getName());
    private static final Pattern TOTAL_MEMORY_PATTERN = Pattern.compile("MemTotal:\\s+(\\d+) kB", 8);
    private static final Pattern FREE_MEMORY_PATTERN = Pattern.compile("MemFree:\\s+(\\d+) kB", 8);
    private static final Pattern TOTAL_SWAP_PATTERN = Pattern.compile("SwapTotal:\\s+(\\d+) kB", 8);
    private static final Pattern FREE_SWAP_PATTERN = Pattern.compile("SwapFree:\\s+(\\d+) kB", 8);
    private static final Pattern CPU_JIFFIES_PATTERN = Pattern.compile("cpu\\s+(.*)", 8);
    private static final Pattern NUM_CPU_PATTERN = Pattern.compile("processor\\s+:\\s+(\\d+)", 8);
    private static final Pattern CPU_FREQ_PATTERN = Pattern.compile("model name[^@]*@\\s+([0-9.A-Za-z]*)", 8);
    private static final Pattern UPTIME_PATTERN = Pattern.compile("([\\d]*).*");
    private static final Pattern PID_PATTERN = Pattern.compile("([\\d]*).*");
    private static final Pattern DISTRIBUTION = Pattern.compile("DISTRIB_DESCRIPTION=\"(.*)\"", 8);
    private FileUtils fileUtils;
    private int userHz = 100;

    LinuxMonitor(FileUtils fileUtils) {
        this.fileUtils = fileUtils;
    }

    public LinuxMonitor() {
        this.fileUtils = new FileUtils();
        JavaSysMon.addSupportedConfig("Linux (only tested with x86)");
        if (System.getProperty("os.name").toLowerCase().startsWith("linux")) {
            JavaSysMon.setMonitor(this);
            JavaSysMon.addSupportedConfig("Linux (only tested with x86)");
        }
    }

    @Override
    public String osName() {
        String string = this.fileUtils.runRegexOnFile(DISTRIBUTION, "/etc/lsb-release");
        if (null == string) {
            return System.getProperty("os.name");
        }
        return string;
    }

    @Override
    public MemoryStats physical() {
        String string = this.fileUtils.runRegexOnFile(TOTAL_MEMORY_PATTERN, "/proc/meminfo");
        long l = Long.parseLong(string) * 1024L;
        String string2 = this.fileUtils.runRegexOnFile(FREE_MEMORY_PATTERN, "/proc/meminfo");
        long l2 = Long.parseLong(string2) * 1024L;
        return new MemoryStats(l2, l);
    }

    @Override
    public MemoryStats swap() {
        String string = this.fileUtils.runRegexOnFile(TOTAL_SWAP_PATTERN, "/proc/meminfo");
        long l = Long.parseLong(string) * 1024L;
        String string2 = this.fileUtils.runRegexOnFile(FREE_SWAP_PATTERN, "/proc/meminfo");
        long l2 = Long.parseLong(string2) * 1024L;
        return new MemoryStats(l2, l);
    }

    @Override
    public int numCpus() {
        int n = 0;
        try {
            String string = this.fileUtils.slurp("/proc/cpuinfo");
            Matcher matcher = NUM_CPU_PATTERN.matcher(string);
            while (matcher.find()) {
                ++n;
            }
            return n;
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    @Override
    public long cpuFrequencyInHz() {
        String string = this.fileUtils.runRegexOnFile(CPU_FREQ_PATTERN, "/proc/cpuinfo");
        int n = string.length();
        BigDecimal bigDecimal = new BigDecimal(string.substring(0, n - 3));
        long l = this.getMultiplier(string.charAt(n - 3));
        return bigDecimal.multiply(new BigDecimal(Long.toString(l))).longValue();
    }

    @Override
    public long uptimeInSeconds() {
        String string = this.fileUtils.runRegexOnFile(UPTIME_PATTERN, "/proc/uptime");
        return Long.parseLong(string);
    }

    @Override
    public int currentPid() {
        String string = this.fileUtils.runRegexOnFile(PID_PATTERN, "/proc/self/stat");
        return Integer.parseInt(string);
    }

    @Override
    public ProcessInfo[] processTable() {
        ArrayList<ProcessInfo> arrayList = new ArrayList<ProcessInfo>();
        String[] stringArray = this.fileUtils.pidsFromProcFilesystem();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                String string = this.fileUtils.slurp("/proc/" + stringArray[i] + "/stat");
                String string2 = this.fileUtils.slurp("/proc/" + stringArray[i] + "/status");
                String string3 = this.fileUtils.slurp("/proc/" + stringArray[i] + "/cmdline");
                UnixPasswdParser unixPasswdParser = new UnixPasswdParser();
                LinuxProcessInfoParser linuxProcessInfoParser = new LinuxProcessInfoParser(string, string2, string3, unixPasswdParser.parse(), this.userHz);
                arrayList.add(linuxProcessInfoParser.parse());
                continue;
            }
            catch (ParseException parseException) {
                LOG.log(Level.WARNING, parseException.getMessage(), parseException);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return arrayList.toArray(new ProcessInfo[arrayList.size()]);
    }

    @Override
    public CpuTimes cpuTimes() {
        String[] stringArray = this.fileUtils.runRegexOnFile(CPU_JIFFIES_PATTERN, "/proc/stat").split("\\s+");
        long l = Long.parseLong(stringArray[0]) + Long.parseLong(stringArray[1]);
        long l2 = Long.parseLong(stringArray[3]);
        long l3 = Long.parseLong(stringArray[2]);
        if (stringArray.length > 4) {
            for (int i = 4; i < stringArray.length; ++i) {
                l3 += Long.parseLong(stringArray[i]);
            }
        }
        return new CpuTimes(this.toMillis(l), this.toMillis(l3), this.toMillis(l2));
    }

    @Override
    public void killProcess(int n) {
        try {
            ProcessKiller.DESTROY_PROCESS.invoke(null, new Integer(n));
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not kill process id " + n, exception);
        }
    }

    private long getMultiplier(char c) {
        switch (c) {
            case 'G': {
                return 1000000000L;
            }
            case 'M': {
                return 1000000L;
            }
            case 'k': {
                return 1000L;
            }
        }
        return 0L;
    }

    private long toMillis(long l) {
        int n = 1000 / this.userHz;
        return l * (long)n;
    }

    private static final class ProcessKiller {
        private static Method DESTROY_PROCESS = null;

        private ProcessKiller() {
        }

        static {
            try {
                Class<?> clazz = Class.forName("java.lang.UNIXProcess");
                DESTROY_PROCESS = clazz.getDeclaredMethod("destroyProcess", Integer.TYPE);
                DESTROY_PROCESS.setAccessible(true);
            }
            catch (Exception exception) {
                LinkageError linkageError = new LinkageError("Couldn't get method java.lang.UNIXProcess.destroyProcess(int)");
                linkageError.initCause(exception);
            }
        }
    }
}

