/*
 * Decompiled with CFR 0.152.
 */
package com.jezhumble.javasysmon;

import com.jezhumble.javasysmon.ParseException;
import com.jezhumble.javasysmon.ProcessInfo;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class LinuxProcessInfoParser {
    private final String stat;
    private final String status;
    private final String cmdline;
    private final HashMap uids;
    private final int userHz;
    private static final Pattern STATUS_NAME_MATCHER = Pattern.compile("Name:\\s+(\\w+)", 8);
    private static final Pattern STATUS_UID_MATCHER = Pattern.compile("Uid:\\s+(\\d+)\\s.*", 8);
    private static final Pattern STATUS_VM_SIZE_MATCHER = Pattern.compile("VmSize:\\s+(\\d+) kB", 8);
    private static final Pattern STATUS_VM_RSS_MATCHER = Pattern.compile("VmRSS:\\s+(\\d+) kB", 8);

    public LinuxProcessInfoParser(String string, String string2, String string3, HashMap hashMap, int n) {
        this.stat = string;
        this.status = string2;
        this.cmdline = string3;
        this.uids = hashMap;
        this.userHz = n;
    }

    public ProcessInfo parse() throws ParseException {
        long l;
        long l2;
        long l3;
        long l4;
        int n;
        int n2;
        int n3 = this.stat.indexOf("(");
        int n4 = this.stat.lastIndexOf(")");
        if (n3 <= 1 || n4 < 0 || n4 > this.stat.length() - 2) {
            throw new ParseException("Stat '" + this.stat + "' does not include expected parens around process name");
        }
        String[] stringArray = this.stat.substring(n4 + 2).split(" ");
        if (stringArray.length < 13) {
            throw new ParseException("Stat '" + this.stat + "' contains fewer elements than expected");
        }
        String string = this.stat.substring(0, n3 - 1);
        try {
            n2 = Integer.parseInt(string);
            n = Integer.parseInt(stringArray[1]);
            l4 = Long.parseLong(stringArray[11]) * (long)(1000 / this.userHz);
            l3 = Long.parseLong(stringArray[12]) * (long)(1000 / this.userHz);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Unable to parse stat '" + this.stat + "'");
        }
        try {
            l2 = Long.parseLong(this.getFirstMatch(STATUS_VM_RSS_MATCHER, this.status)) * 1024L;
            l = Long.parseLong(this.getFirstMatch(STATUS_VM_SIZE_MATCHER, this.status)) * 1024L;
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Unable to extract memory usage information from status '" + this.status + "'");
        }
        return new ProcessInfo(n2, n, this.trim(this.cmdline), this.getFirstMatch(STATUS_NAME_MATCHER, this.status), (String)this.uids.get(this.getFirstMatch(STATUS_UID_MATCHER, this.status)), l4, l3, l2, l);
    }

    private String trim(String string) {
        return string.replace('\u0000', ' ').replace('\n', ' ');
    }

    public String getFirstMatch(Pattern pattern, String string) {
        try {
            Matcher matcher = pattern.matcher(string);
            matcher.find();
            return matcher.group(1);
        }
        catch (Exception exception) {
            return "0";
        }
    }
}

