/*
 * Decompiled with CFR 0.152.
 */
package com.jezhumble.javasysmon;

import com.jezhumble.javasysmon.CpuTimes;
import com.jezhumble.javasysmon.JavaSysMon;
import com.jezhumble.javasysmon.MemoryStats;
import com.jezhumble.javasysmon.Monitor;
import com.jezhumble.javasysmon.NativeLibraryLoader;
import com.jezhumble.javasysmon.ProcessInfo;

class MacOsXMonitor
implements Monitor {
    private static Monitor monitor = null;

    public MacOsXMonitor() {
        JavaSysMon.addSupportedConfig("Mac Os X (PPC, x86, X86_64)");
        if (monitor != null) {
            JavaSysMon.setMonitor(monitor);
        }
    }

    @Override
    public String osName() {
        return System.getProperty("os.name") + " " + System.getProperty("os.version");
    }

    @Override
    public native int numCpus();

    @Override
    public native long cpuFrequencyInHz();

    @Override
    public native long uptimeInSeconds();

    @Override
    public native int currentPid();

    @Override
    public native CpuTimes cpuTimes();

    @Override
    public native MemoryStats physical();

    @Override
    public native MemoryStats swap();

    @Override
    public native ProcessInfo[] processTable();

    @Override
    public native void killProcess(int var1);

    static {
        if (System.getProperty("os.name").toLowerCase().equals("mac os x")) {
            new NativeLibraryLoader().loadLibrary("libjavasysmon.jnilib");
            monitor = new MacOsXMonitor();
        }
    }
}

