/*
 * Decompiled with CFR 0.152.
 */
package com.jezhumble.javasysmon;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class NativeLibraryLoader {
    public static final String JAVA_SYS_MON_TEMP_DIR = "JAVA_SYS_MON_TEMP_DIR";

    NativeLibraryLoader() {
    }

    public void loadLibrary(String string) {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("/" + string);
            File file = this.getTempFile(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.copyAndClose(inputStream, fileOutputStream);
            System.load(file.getAbsolutePath());
        }
        catch (IOException iOException) {
            throw new RuntimeException("Couldn't load native library " + string, iOException);
        }
    }

    private void copyAndClose(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
        inputStream.close();
        outputStream.close();
    }

    File getTempFile(String string) throws IOException {
        int n = string.lastIndexOf(".");
        String string2 = null;
        String string3 = string;
        if (n >= 0) {
            string2 = string.substring(n);
            string3 = string.substring(0, n - 1);
        }
        File file = this.createTempFile(string2, string3);
        file.deleteOnExit();
        return file;
    }

    private File createTempFile(String string, String string2) throws IOException {
        String string3 = System.getProperty(JAVA_SYS_MON_TEMP_DIR);
        if (string3 == null || string3.trim().length() == 0) {
            return File.createTempFile(string2, string);
        }
        return File.createTempFile(string2, string, new File(string3));
    }
}

