/*
 * Decompiled with CFR 0.152.
 */
package com.jezhumble.javasysmon;

import com.jezhumble.javasysmon.JavaSysMon;
import com.jezhumble.javasysmon.ProcessInfo;
import com.jezhumble.javasysmon.ProcessVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class OsProcess {
    private final ArrayList children = new ArrayList();
    private final ProcessInfo processInfo;

    private OsProcess(ProcessInfo processInfo) {
        this.processInfo = processInfo;
    }

    public static OsProcess createTree(ProcessInfo[] processInfoArray) {
        int n;
        HashMap<Integer, OsProcess> hashMap = new HashMap<Integer, OsProcess>();
        OsProcess osProcess = new OsProcess(null);
        for (n = 0; n < processInfoArray.length; ++n) {
            OsProcess osProcess2 = new OsProcess(processInfoArray[n]);
            hashMap.put(new Integer(processInfoArray[n].getPid()), osProcess2);
        }
        for (n = 0; n < processInfoArray.length; ++n) {
            int n2 = processInfoArray[n].getPid();
            int n3 = processInfoArray[n].getParentPid();
            OsProcess osProcess3 = (OsProcess)hashMap.get(new Integer(n2));
            if (n3 == n2 || !hashMap.containsKey(new Integer(n3))) {
                osProcess.children.add(osProcess3);
                continue;
            }
            ((OsProcess)hashMap.get((Object)new Integer((int)n3))).children.add(osProcess3);
        }
        return osProcess;
    }

    public List children() {
        return this.children;
    }

    public ProcessInfo processInfo() {
        return this.processInfo;
    }

    public OsProcess find(int n) {
        if (this.processInfo != null && this.processInfo.getPid() == n) {
            return this;
        }
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            OsProcess osProcess = ((OsProcess)iterator.next()).find(n);
            if (osProcess == null) continue;
            return osProcess;
        }
        return null;
    }

    public void accept(ProcessVisitor processVisitor, int n) {
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            ((OsProcess)iterator.next()).accept(processVisitor, n + 1);
        }
        if (this.processInfo != null && processVisitor.visit(this, n)) {
            new JavaSysMon().killProcess(this.processInfo.getPid());
        }
    }
}

