/*
 * Decompiled with CFR 0.152.
 */
package com.jezhumble.javasysmon;

import java.text.DecimalFormat;

public class ProcessInfo {
    private int pid;
    private int parentPid;
    private String command;
    private String name;
    private String owner;
    private long userMillis;
    private long systemMillis;
    private long residentBytes;
    private long totalBytes;
    private static final String PADDING = "                                                                                   ";

    public ProcessInfo(int n, int n2, String string, String string2, String string3, long l, long l2, long l3, long l4) {
        this.pid = n;
        this.parentPid = n2;
        this.command = string;
        this.name = string2;
        this.owner = string3;
        this.userMillis = l;
        this.systemMillis = l2;
        this.residentBytes = l3;
        this.totalBytes = l4;
    }

    public int getPid() {
        return this.pid;
    }

    public int getParentPid() {
        return this.parentPid;
    }

    public String getCommand() {
        return this.command;
    }

    public String getName() {
        return this.name;
    }

    public String getOwner() {
        return this.owner;
    }

    public long getUserMillis() {
        return this.userMillis;
    }

    public long getSystemMillis() {
        return this.systemMillis;
    }

    public long getResidentBytes() {
        return this.residentBytes;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public static String header() {
        return "  pid name        ppid user        total    res     time command\n================================================================================";
    }

    public String toString() {
        return ProcessInfo.stringFormat(this.pid, 5) + " " + ProcessInfo.stringFormat(this.name, 10) + " " + ProcessInfo.stringFormat(this.parentPid, 5) + " " + ProcessInfo.stringFormat(this.owner, 10) + " " + ProcessInfo.stringFormat(this.totalBytes / 0x100000L, 4) + "Mb " + ProcessInfo.stringFormat(this.residentBytes / 0x100000L, 4) + "Mb " + ProcessInfo.formatMillisecs(this.userMillis + this.systemMillis) + " " + ProcessInfo.stringFormat(this.command, 23);
    }

    private static String stringFormat(int n, int n2) {
        return ProcessInfo.stringFormat(Integer.toString(n), n2, true);
    }

    private static String stringFormat(long l, int n) {
        return ProcessInfo.stringFormat(Long.toString(l), n, true);
    }

    private static String stringFormat(String string, int n) {
        return ProcessInfo.stringFormat(string, n, false);
    }

    private static String stringFormat(String string, int n, boolean bl) {
        if (string.length() >= n) {
            return string.substring(0, n);
        }
        return bl ? PADDING.substring(0, n - string.length()) + string : string + PADDING.substring(0, n - string.length());
    }

    private static String formatMillisecs(long l) {
        long l2 = l / 1000L;
        long l3 = l2 / 3600L;
        long l4 = (l2 - l3 * 3600L) / 60L;
        l2 = l2 - l3 * 3600L - l4 * 60L;
        DecimalFormat decimalFormat = new DecimalFormat("00");
        return decimalFormat.format(l3) + ":" + decimalFormat.format(l4) + ":" + decimalFormat.format(l2);
    }
}

