/*
 * Decompiled with CFR 0.152.
 */
package com.jezhumble.javasysmon;

import com.jezhumble.javasysmon.CpuTimes;
import com.jezhumble.javasysmon.JavaSysMon;
import com.jezhumble.javasysmon.MemoryStats;
import com.jezhumble.javasysmon.Monitor;
import com.jezhumble.javasysmon.NativeLibraryLoader;
import com.jezhumble.javasysmon.ProcessInfo;

class WindowsMonitor
implements Monitor {
    private static Monitor monitor = null;

    public WindowsMonitor() {
        JavaSysMon.addSupportedConfig("Windows (x86)");
        if (monitor != null) {
            JavaSysMon.setMonitor(monitor);
        }
    }

    @Override
    public String osName() {
        return System.getProperty("os.name");
    }

    @Override
    public native int numCpus();

    @Override
    public native int currentPid();

    @Override
    public native long cpuFrequencyInHz();

    @Override
    public native long uptimeInSeconds();

    @Override
    public native CpuTimes cpuTimes();

    @Override
    public native MemoryStats physical();

    @Override
    public native MemoryStats swap();

    @Override
    public native ProcessInfo[] processTable();

    @Override
    public native void killProcess(int var1);

    static {
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            if (System.getProperty("os.arch").indexOf("64") > -1) {
                new NativeLibraryLoader().loadLibrary("javasysmon64.dll");
            } else {
                new NativeLibraryLoader().loadLibrary("javasysmon.dll");
            }
            monitor = new WindowsMonitor();
        }
    }
}

