/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tokens.auth;

import java.util.UUID;

final class UuidStringConverter {
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();

    private UuidStringConverter() {
    }

    static String toString(UUID value) {
        char[] ch = new char[36];
        long msb = value.getMostSignificantBits();
        UuidStringConverter.writeInt((int)(msb >> 32), ch, 0);
        ch[8] = 45;
        int intBytes = (int)msb;
        UuidStringConverter.writeShort(intBytes >>> 16, ch, 9);
        ch[13] = 45;
        UuidStringConverter.writeShort(intBytes, ch, 14);
        ch[18] = 45;
        long lsb = value.getLeastSignificantBits();
        UuidStringConverter.writeShort((int)(lsb >>> 48), ch, 19);
        ch[23] = 45;
        UuidStringConverter.writeShort((int)(lsb >>> 32), ch, 24);
        UuidStringConverter.writeInt((int)lsb, ch, 28);
        return new String(ch);
    }

    private static void writeInt(int bits, char[] ch, int offset) {
        UuidStringConverter.writeShort(bits >> 16, ch, offset);
        UuidStringConverter.writeShort(bits, ch, offset + 4);
    }

    private static void writeShort(int bits, char[] ch, int offset) {
        ch[offset] = HEX_CHARS[bits >> 12 & 0xF];
        ch[offset + 1] = HEX_CHARS[bits >> 8 & 0xF];
        ch[offset + 2] = HEX_CHARS[bits >> 4 & 0xF];
        ch[offset + 3] = HEX_CHARS[bits & 0xF];
    }
}

