/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.lang;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.InRange;
import com.pholser.junit.quickcheck.generator.IntegralGenerator;
import com.pholser.junit.quickcheck.internal.Comparables;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Predicate;

public class LongGenerator
extends IntegralGenerator<Long> {
    private long min = (Long)Reflection.defaultValueOf(InRange.class, (String)"minLong");
    private long max = (Long)Reflection.defaultValueOf(InRange.class, (String)"maxLong");

    public LongGenerator() {
        super(Arrays.asList(Long.class, Long.TYPE));
    }

    public void configure(InRange range) {
        this.min = range.min().isEmpty() ? range.minLong() : Long.parseLong(range.min());
        this.max = range.max().isEmpty() ? range.maxLong() : Long.parseLong(range.max());
    }

    public Long generate(SourceOfRandomness random, GenerationStatus status) {
        return random.nextLong(this.min, this.max);
    }

    @Override
    protected Function<BigInteger, Long> narrow() {
        return BigInteger::longValue;
    }

    @Override
    protected Predicate<Long> inRange() {
        return Comparables.inRange((Comparable)Long.valueOf(this.min), (Comparable)Long.valueOf(this.max));
    }

    @Override
    protected Long leastMagnitude() {
        return (Long)Comparables.leastMagnitude((Comparable)Long.valueOf(this.min), (Comparable)Long.valueOf(this.max), (Comparable)Long.valueOf(0L));
    }

    @Override
    protected boolean negative(Long target) {
        return target < 0L;
    }

    @Override
    protected Long negate(Long target) {
        return -target.longValue();
    }

    public BigDecimal magnitude(Object value) {
        return BigDecimal.valueOf((Long)this.narrow(value));
    }
}

