/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.time;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.InRange;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

public class OffsetTimeGenerator
extends Generator<OffsetTime> {
    private OffsetTime min = OffsetTime.MIN;
    private OffsetTime max = OffsetTime.MAX;

    public OffsetTimeGenerator() {
        super(OffsetTime.class);
    }

    public void configure(InRange range) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(range.format());
        if (!Reflection.defaultValueOf(InRange.class, (String)"min").equals(range.min())) {
            this.min = OffsetTime.parse(range.min(), formatter);
        }
        if (!Reflection.defaultValueOf(InRange.class, (String)"max").equals(range.max())) {
            this.max = OffsetTime.parse(range.max(), formatter);
        }
        if (this.min.compareTo(this.max) > 0) {
            throw new IllegalArgumentException(String.format("bad range, %s > %s", this.min, this.max));
        }
    }

    public OffsetTime generate(SourceOfRandomness random, GenerationStatus status) {
        LocalTime time = LocalTime.ofNanoOfDay(random.nextLong(this.min.withOffsetSameInstant(ZoneOffset.UTC).toLocalTime().toNanoOfDay(), this.max.withOffsetSameInstant(ZoneOffset.UTC).toLocalTime().toNanoOfDay()));
        return OffsetTime.of(time, ZoneOffset.UTC);
    }
}

