/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.time;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.InRange;
import com.pholser.junit.quickcheck.internal.Ranges;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.math.BigInteger;
import java.time.Period;

public class PeriodGenerator
extends Generator<Period> {
    private static final BigInteger TWELVE = BigInteger.valueOf(12L);
    private static final BigInteger THIRTY_ONE = BigInteger.valueOf(31L);
    private Period min = Period.of(-999999999, -12, -31);
    private Period max = Period.of(999999999, 12, 31);

    public PeriodGenerator() {
        super(Period.class);
    }

    public void configure(InRange range) {
        if (!Reflection.defaultValueOf(InRange.class, (String)"min").equals(range.min())) {
            this.min = Period.parse(range.min());
        }
        if (!Reflection.defaultValueOf(InRange.class, (String)"max").equals(range.max())) {
            this.max = Period.parse(range.max());
        }
        if (this.toBigInteger(this.min).compareTo(this.toBigInteger(this.max)) > 0) {
            throw new IllegalArgumentException(String.format("bad range, %s > %s", this.min, this.max));
        }
    }

    public Period generate(SourceOfRandomness random, GenerationStatus status) {
        return this.fromBigInteger(Ranges.choose((SourceOfRandomness)random, (BigInteger)this.toBigInteger(this.min), (BigInteger)this.toBigInteger(this.max)));
    }

    private BigInteger toBigInteger(Period period) {
        return BigInteger.valueOf(period.getYears()).multiply(TWELVE).add(BigInteger.valueOf(period.getMonths())).multiply(THIRTY_ONE).add(BigInteger.valueOf(period.getDays()));
    }

    private Period fromBigInteger(BigInteger period) {
        BigInteger[] monthsAndDays = period.divideAndRemainder(THIRTY_ONE);
        BigInteger[] yearsAndMonths = monthsAndDays[0].divideAndRemainder(TWELVE);
        return Period.of(yearsAndMonths[0].intValueExact(), yearsAndMonths[1].intValueExact(), monthsAndDays[1].intValueExact());
    }
}

