/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.time;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.InRange;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;

public class YearMonthGenerator
extends Generator<YearMonth> {
    private YearMonth min = YearMonth.of(-999999999, 1);
    private YearMonth max = YearMonth.of(999999999, 12);

    public YearMonthGenerator() {
        super(YearMonth.class);
    }

    public void configure(InRange range) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(range.format());
        if (!Reflection.defaultValueOf(InRange.class, (String)"min").equals(range.min())) {
            this.min = YearMonth.parse(range.min(), formatter);
        }
        if (!Reflection.defaultValueOf(InRange.class, (String)"max").equals(range.max())) {
            this.max = YearMonth.parse(range.max(), formatter);
        }
        if (this.min.compareTo(this.max) > 0) {
            throw new IllegalArgumentException(String.format("bad range, %s > %s", this.min, this.max));
        }
    }

    public YearMonth generate(SourceOfRandomness random, GenerationStatus status) {
        long generated = random.nextLong((long)this.min.getYear() * 12L + (long)this.min.getMonthValue() - 1L, (long)this.max.getYear() * 12L + (long)this.max.getMonthValue() - 1L);
        return YearMonth.of((int)(generated / 12L), (int)Math.abs(generated % 12L) + 1);
    }
}

