/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.util;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.InRange;
import com.pholser.junit.quickcheck.generator.java.lang.DoubleGenerator;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalDouble;
import java.util.stream.Collectors;

public class OptionalDoubleGenerator
extends Generator<OptionalDouble> {
    private final DoubleGenerator doubles = new DoubleGenerator();

    public OptionalDoubleGenerator() {
        super(OptionalDouble.class);
    }

    public void configure(InRange range) {
        this.doubles.configure(range);
    }

    public OptionalDouble generate(SourceOfRandomness random, GenerationStatus status) {
        double trial = random.nextDouble();
        return trial < 0.25 ? OptionalDouble.empty() : OptionalDouble.of(this.doubles.generate(random, status));
    }

    public List<OptionalDouble> doShrink(SourceOfRandomness random, OptionalDouble larger) {
        if (!larger.isPresent()) {
            return new ArrayList<OptionalDouble>();
        }
        ArrayList<OptionalDouble> shrinks = new ArrayList<OptionalDouble>();
        shrinks.add(OptionalDouble.empty());
        shrinks.addAll(this.doubles.shrink(random, larger.getAsDouble()).stream().map(OptionalDouble::of).collect(Collectors.toList()));
        return shrinks;
    }

    public BigDecimal magnitude(Object value) {
        OptionalDouble narrowed = (OptionalDouble)this.narrow(value);
        return narrowed.isPresent() ? this.doubles.magnitude(narrowed.getAsDouble()) : BigDecimal.ZERO;
    }
}

