/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.internal;

import com.pinterest.ktlint.core.LintError;
import com.pinterest.ktlint.internal.CurrentBaseline;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001H\u0000\u001a\"\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u001a\u0010\u0012\u001a\u00020\u0013*\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0014\u001a\u00020\u000bH\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0015"}, d2={"relativeRoute", "", "Ljava/io/File;", "getRelativeRoute", "(Ljava/io/File;)Ljava/lang/String;", "loadBaseline", "Lcom/pinterest/ktlint/internal/CurrentBaseline;", "baselineFilePath", "parseBaseline", "", "", "Lcom/pinterest/ktlint/core/LintError;", "baselineFile", "Ljava/io/InputStream;", "parseBaselineErrorsByFile", "", "element", "Lorg/w3c/dom/Element;", "containsLintError", "", "error", "ktlint"})
public final class BaselineUtilsKt {
    @NotNull
    public static final CurrentBaseline loadBaseline(@NotNull String baselineFilePath) {
        Intrinsics.checkParameterIsNotNull((Object)baselineFilePath, (String)"baselineFilePath");
        if (StringsKt.isBlank((CharSequence)baselineFilePath)) {
            return new CurrentBaseline(null, false);
        }
        Map<String, List<LintError>> baselineRules = null;
        boolean baselineGenerationNeeded = true;
        File baselineFile = Paths.get(baselineFilePath, new String[0]).toFile();
        if (baselineFile.exists()) {
            try {
                File file = baselineFile;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"baselineFile");
                File file2 = file;
                boolean bl = false;
                baselineRules = BaselineUtilsKt.parseBaseline(new FileInputStream(file2));
                baselineGenerationNeeded = false;
            }
            catch (IOException e) {
                System.err.println("Unable to parse baseline file: " + baselineFilePath);
                baselineGenerationNeeded = true;
            }
            catch (ParserConfigurationException e) {
                System.err.println("Unable to parse baseline file: " + baselineFilePath);
                baselineGenerationNeeded = true;
            }
            catch (SAXException e) {
                System.err.println("Unable to parse baseline file: " + baselineFilePath);
                baselineGenerationNeeded = true;
            }
        }
        if (baselineGenerationNeeded && baselineFile.exists()) {
            baselineFile.delete();
        }
        return new CurrentBaseline((Map<String, ? extends List<LintError>>)baselineRules, baselineGenerationNeeded);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, List<LintError>> parseBaseline(@NotNull InputStream baselineFile) {
        Intrinsics.checkParameterIsNotNull((Object)baselineFile, (String)"baselineFile");
        HashMap baselineRules = new HashMap();
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = builderFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(baselineFile);
        NodeList filesList = doc.getElementsByTagName("file");
        int n = 0;
        NodeList nodeList = filesList;
        Intrinsics.checkExpressionValueIsNotNull((Object)nodeList, (String)"filesList");
        int n2 = nodeList.getLength();
        while (n < n2) {
            void i;
            Node node = filesList.item((int)i);
            if (node == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.w3c.dom.Element");
            }
            Element fileElement = (Element)node;
            String fileName = fileElement.getAttribute("name");
            List<LintError> baselineErrors = BaselineUtilsKt.parseBaselineErrorsByFile(fileElement);
            Map map = baselineRules;
            String string = fileName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fileName");
            map.put(string, baselineErrors);
            ++i;
        }
        return baselineRules;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<LintError> parseBaselineErrorsByFile(Element element) {
        boolean bl = false;
        List errors = new ArrayList();
        NodeList errorsList = element.getElementsByTagName("error");
        int n = 0;
        NodeList nodeList = errorsList;
        Intrinsics.checkExpressionValueIsNotNull((Object)nodeList, (String)"errorsList");
        int n2 = nodeList.getLength();
        while (n < n2) {
            void i;
            Node node = errorsList.item((int)i);
            if (node == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.w3c.dom.Element");
            }
            Element errorElement = (Element)node;
            String string = errorElement.getAttribute("line");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"errorElement.getAttribute(\"line\")");
            String string2 = string;
            boolean bl2 = false;
            int n3 = Integer.parseInt(string2);
            String string3 = errorElement.getAttribute("column");
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"errorElement.getAttribute(\"column\")");
            string2 = string3;
            bl2 = false;
            int n4 = Integer.parseInt(string2);
            String string4 = errorElement.getAttribute("source");
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"errorElement.getAttribute(\"source\")");
            errors.add(new LintError(n3, n4, string4, ""));
            ++i;
        }
        return errors;
    }

    public static final boolean containsLintError(@NotNull List<LintError> $this$containsLintError, @NotNull LintError error) {
        Object v0;
        block1: {
            Intrinsics.checkParameterIsNotNull($this$containsLintError, (String)"$this$containsLintError");
            Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
            Iterable $this$firstOrNull$iv = $this$containsLintError;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                LintError lintError = (LintError)element$iv;
                boolean bl = false;
                if (!(lintError.getCol() == error.getCol() && lintError.getLine() == error.getLine() && Intrinsics.areEqual((Object)lintError.getRuleId(), (Object)error.getRuleId()))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0 != null;
    }

    @NotNull
    public static final String getRelativeRoute(@NotNull File $this$relativeRoute) {
        Intrinsics.checkParameterIsNotNull((Object)$this$relativeRoute, (String)"$this$relativeRoute");
        Path rootPath = Paths.get("", new String[0]).toAbsolutePath();
        Path filePath = $this$relativeRoute.toPath();
        return StringsKt.replace$default((String)((Object)rootPath.relativize(filePath)).toString(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
    }
}

