/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard;

import com.pinterest.ktlint.core.EditorConfig;
import com.pinterest.ktlint.core.KtLint;
import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import com.pinterest.ktlint.ruleset.standard.ImportOrderingRule;
import com.pinterest.ktlint.ruleset.standard.internal.importordering.ImportSorter;
import com.pinterest.ktlint.ruleset.standard.internal.importordering.PatternEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 !2\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a2\u0006\u0002\u0010\fJ$\u0010\r\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0002J\b\u0010\u0011\u001a\u00020\bH\u0002Je\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\b2K\u0010\u0016\u001aG\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001c\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\u00130\u0017H\u0016J\u0014\u0010\u001e\u001a\u00020\u0006*\u00020\u001f2\u0006\u0010 \u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/pinterest/ktlint/ruleset/standard/ImportOrderingRule;", "Lcom/pinterest/ktlint/core/Rule;", "()V", "importSorter", "Lcom/pinterest/ktlint/ruleset/standard/internal/importordering/ImportSorter;", "importsLayout", "", "hasTooMuchWhitespace", "", "nodes", "", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "([Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;)Z", "importsAreEqual", "actual", "", "expected", "isCustomLayout", "visit", "", "node", "autoCorrect", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "errorMessage", "canBeAutoCorrected", "resolveImportsLayout", "Lcom/pinterest/ktlint/core/EditorConfig;", "android", "Companion", "ktlint-ruleset-standard"})
public final class ImportOrderingRule
extends Rule {
    private String importsLayout;
    private ImportSorter importSorter;
    private static final String ASCII_PATTERN = "*";
    private static final String IDEA_PATTERN = "*,java.*,javax.*,kotlin.*,^*";
    private static final String IDEA_ERROR_MESSAGE = "Imports must be ordered in lexicographic order without any empty lines in-between with \"java\", \"javax\", \"kotlin\" and aliases in the end";
    private static final String ASCII_ERROR_MESSAGE = "Imports must be ordered in lexicographic order without any empty lines in-between";
    private static final String CUSTOM_ERROR_MESSAGE = "Imports must be ordered according to the pattern specified in .editorconfig";
    private static final Map<String, String> errorMessages;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(emit, (String)"emit");
        if (PackageKt.isRoot((ASTNode)node)) {
            Boolean bl = (Boolean)node.getUserData(KtLint.INSTANCE.getANDROID_USER_DATA_KEY());
            if (bl == null) {
                bl = false;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"node.getUserData(KtLint.\u2026D_USER_DATA_KEY) ?: false");
            boolean android = bl;
            Object object = node.getUserData(KtLint.INSTANCE.getEDITOR_CONFIG_USER_DATA_KEY());
            if (object == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"node.getUserData(KtLint.\u2026R_CONFIG_USER_DATA_KEY)!!");
            EditorConfig editorConfig = (EditorConfig)object;
            String string = this.importsLayout = this.resolveImportsLayout(editorConfig, android);
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"importsLayout");
            }
            this.importSorter = new ImportSorter(string);
            return;
        }
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getIMPORT_LIST())) {
            ASTNode[] children;
            ASTNode[] aSTNodeArray = node.getChildren(null);
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNodeArray, (String)"node.getChildren(null)");
            ASTNode[] editorConfig = children = aSTNodeArray;
            boolean bl = false;
            ASTNode[] aSTNodeArray2 = editorConfig;
            boolean bl2 = false;
            if (!(aSTNodeArray2.length == 0)) {
                boolean canAutoCorrect;
                ASTNode current;
                void $this$fold$iv;
                ASTNode aSTNode;
                List imports;
                ASTNode it;
                block28: {
                    ASTNode element$iv$iv;
                    int n;
                    void $this$filterTo$iv$iv22;
                    ASTNode[] $this$filter$iv = children;
                    boolean $i$f$filter22 = false;
                    ASTNode[] aSTNodeArray3 = $this$filter$iv;
                    ASTNode[] destination$iv$iv22 = (ASTNode[])new ArrayList();
                    boolean $i$f$filterTo = false;
                    ASTNode[] aSTNodeArray4 = $this$filterTo$iv$iv22;
                    int n2 = aSTNodeArray4.length;
                    for (n = 0; n < n2; ++n) {
                        it = element$iv$iv = aSTNodeArray4[n];
                        boolean bl3 = false;
                        void v4 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"it");
                        if (!(Intrinsics.areEqual((Object)v4.getElementType(), (Object)ElementType.INSTANCE.getIMPORT_DIRECTIVE()) || it.getPsi() instanceof PsiWhiteSpace && it.getTextLength() > 1)) continue;
                        destination$iv$iv22.add(element$iv$iv);
                    }
                    imports = (List)destination$iv$iv22;
                    ASTNode[] $i$f$filter22 = children;
                    boolean $this$filterTo$iv$iv22 = false;
                    destination$iv$iv22 = $i$f$filter22;
                    $i$f$filterTo = false;
                    aSTNodeArray4 = destination$iv$iv22;
                    n2 = aSTNodeArray4.length;
                    for (n = 0; n < n2; ++n) {
                        it = element$iv$iv = aSTNodeArray4[n];
                        boolean bl4 = false;
                        ASTNode aSTNode2 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode2, (String)"it");
                        if (!(Intrinsics.areEqual((Object)aSTNode2.getElementType(), (Object)ElementType.INSTANCE.getBLOCK_COMMENT()) || Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getEOL_COMMENT()))) continue;
                        aSTNode = element$iv$iv;
                        break block28;
                    }
                    aSTNode = null;
                }
                boolean hasComments = aSTNode != null;
                Sequence sequence = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)imports), (Function1)visit.sortedImports.1.INSTANCE), (Function1)visit.sortedImports.2.INSTANCE);
                ImportSorter importSorter = this.importSorter;
                if (importSorter == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"importSorter");
                }
                Sequence sortedImports2 = SequencesKt.map((Sequence)SequencesKt.distinctBy((Sequence)SequencesKt.sortedWith((Sequence)sequence, (Comparator)importSorter), (Function1)visit.sortedImports.3.INSTANCE), (Function1)visit.sortedImports.4.INSTANCE);
                boolean destination$iv$iv22 = false;
                List sortedImportsWithSpaces = new ArrayList();
                Sequence destination$iv$iv22 = sortedImports2;
                ASTNode initial$iv = null;
                boolean $i$f$fold = false;
                ASTNode accumulator$iv = initial$iv;
                for (Object element$iv : $this$fold$iv) {
                    int n;
                    it = (ASTNode)element$iv;
                    ASTNode prev = accumulator$iv;
                    boolean bl5 = false;
                    if (prev == null) {
                        n = -1;
                    } else {
                        ImportSorter importSorter2 = this.importSorter;
                        if (importSorter2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"importSorter");
                        }
                        PsiElement psiElement = prev.getPsi();
                        if (psiElement == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtImportDirective");
                        }
                        ImportPath importPath = ((KtImportDirective)psiElement).getImportPath();
                        if (importPath == null) {
                            Intrinsics.throwNpe();
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)importPath, (String)"(prev.psi as KtImportDirective).importPath!!");
                        n = importSorter2.findImportIndex(importPath);
                    }
                    int index1 = n;
                    ImportSorter importSorter3 = this.importSorter;
                    if (importSorter3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"importSorter");
                    }
                    void v14 = current;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v14, (String)"current");
                    PsiElement psiElement = v14.getPsi();
                    if (psiElement == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtImportDirective");
                    }
                    ImportPath importPath = ((KtImportDirective)psiElement).getImportPath();
                    if (importPath == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)importPath, (String)"(current.psi as KtImportDirective).importPath!!");
                    int index2 = importSorter3.findImportIndex(importPath);
                    boolean hasBlankLines = false;
                    int n3 = index1 + 1;
                    int n4 = index2;
                    while (n3 < n4) {
                        void i;
                        ImportSorter importSorter4 = this.importSorter;
                        if (importSorter4 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"importSorter");
                        }
                        if (Intrinsics.areEqual((Object)importSorter4.getPatterns().get((int)i), (Object)PatternEntry.Companion.getBLANK_LINE_ENTRY())) {
                            hasBlankLines = true;
                            break;
                        }
                        ++i;
                    }
                    if (hasBlankLines) {
                        Collection collection = sortedImportsWithSpaces;
                        PsiWhiteSpaceImpl psiWhiteSpaceImpl = new PsiWhiteSpaceImpl((CharSequence)"\n\n");
                        boolean bl6 = false;
                        collection.add(psiWhiteSpaceImpl);
                    }
                    Collection collection = sortedImportsWithSpaces;
                    n4 = 0;
                    collection.add(current);
                    accumulator$iv = current;
                }
                boolean bl7 = canAutoCorrect = !hasComments;
                if (!this.importsAreEqual(imports, sortedImportsWithSpaces) || this.hasTooMuchWhitespace(children) && !this.isCustomLayout()) {
                    String additionalMessage = !canAutoCorrect ? " -- no autocorrection due to comments in the import list" : "";
                    Integer n = node.getStartOffset();
                    StringBuilder stringBuilder = new StringBuilder();
                    String string = this.importsLayout;
                    if (string == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"importsLayout");
                    }
                    emit.invoke((Object)n, (Object)stringBuilder.append(errorMessages.getOrDefault(string, CUSTOM_ERROR_MESSAGE)).append(additionalMessage).toString(), (Object)canAutoCorrect);
                    if (autoCorrect && canAutoCorrect) {
                        ASTNode aSTNode3 = node.getFirstChildNode();
                        ASTNode aSTNode4 = node.getLastChildNode();
                        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode4, (String)"node.lastChildNode");
                        node.removeRange(aSTNode3, aSTNode4.getTreeNext());
                        Iterable $this$reduce$iv = sortedImportsWithSpaces;
                        boolean $i$f$reduce = false;
                        Iterator iterator$iv = $this$reduce$iv.iterator();
                        if (!iterator$iv.hasNext()) {
                            throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
                        }
                        Object accumulator$iv2 = iterator$iv.next();
                        while (iterator$iv.hasNext()) {
                            void next;
                            current = (ASTNode)iterator$iv.next();
                            ASTNode current2 = (ASTNode)accumulator$iv2;
                            boolean bl8 = false;
                            node.addChild(current2, null);
                            if (!(current2 instanceof PsiWhiteSpace) && !(next instanceof PsiWhiteSpace)) {
                                node.addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n"), null);
                            }
                            accumulator$iv2 = next;
                        }
                        node.addChild((ASTNode)CollectionsKt.last((List)sortedImportsWithSpaces), null);
                    }
                }
            }
        }
    }

    private final String resolveImportsLayout(@NotNull EditorConfig $this$resolveImportsLayout, boolean android) {
        String string;
        String string2;
        String defaultPattern = android ? "ascii" : "idea";
        CharSequence charSequence = $this$resolveImportsLayout.get("kotlin_imports_layout");
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || charSequence.length() == 0)) {
            string2 = $this$resolveImportsLayout.get("kotlin_imports_layout");
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
        } else {
            charSequence = $this$resolveImportsLayout.get("ij_kotlin_imports_layout");
            bl = false;
            bl2 = false;
            if (!(charSequence == null || charSequence.length() == 0)) {
                string2 = $this$resolveImportsLayout.get("ij_kotlin_imports_layout");
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
            } else {
                string2 = defaultPattern;
            }
        }
        String layout = string2;
        switch (layout) {
            case "idea": {
                string = IDEA_PATTERN;
                break;
            }
            case "ascii": {
                string = ASCII_PATTERN;
                break;
            }
            default: {
                string = layout;
            }
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean importsAreEqual(List<? extends ASTNode> actual, List<? extends ASTNode> expected) {
        boolean bl;
        block4: {
            if (actual.size() != expected.size()) {
                return false;
            }
            List combined = CollectionsKt.zip((Iterable)actual, (Iterable)expected);
            Iterable $this$all$iv = combined;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    void first;
                    Pair $dstr$first$second = (Pair)element$iv;
                    boolean bl2 = false;
                    ASTNode aSTNode = (ASTNode)$dstr$first$second.component1();
                    ASTNode second = (ASTNode)$dstr$first$second.component2();
                    if (first instanceof PsiWhiteSpace && second instanceof PsiWhiteSpace ? Intrinsics.areEqual((Object)((PsiWhiteSpace)first).getText(), (Object)((PsiWhiteSpace)second).getText()) : Intrinsics.areEqual((Object)first, (Object)second)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCustomLayout() {
        String string = this.importsLayout;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"importsLayout");
        }
        if (!(Intrinsics.areEqual((Object)string, (Object)IDEA_PATTERN) ^ true)) return false;
        String string2 = this.importsLayout;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"importsLayout");
        }
        if (!(Intrinsics.areEqual((Object)string2, (Object)ASCII_PATTERN) ^ true)) return false;
        return true;
    }

    private final boolean hasTooMuchWhitespace(ASTNode[] nodes) {
        boolean bl;
        block1: {
            ASTNode[] $this$any$iv = nodes;
            boolean $i$f$any = false;
            ASTNode[] aSTNodeArray = $this$any$iv;
            int n = aSTNodeArray.length;
            for (int i = 0; i < n; ++i) {
                ASTNode element$iv;
                ASTNode it = element$iv = aSTNodeArray[i];
                boolean bl2 = false;
                if (!(it instanceof PsiWhiteSpace && Intrinsics.areEqual((Object)((PsiWhiteSpace)it).getText(), (Object)"\n") ^ true)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public ImportOrderingRule() {
        super("import-ordering");
    }

    static {
        Companion = new Companion(null);
        errorMessages = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)IDEA_PATTERN, (Object)IDEA_ERROR_MESSAGE), TuplesKt.to((Object)ASCII_PATTERN, (Object)ASCII_ERROR_MESSAGE)});
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/ImportOrderingRule$Companion;", "", "()V", "ASCII_ERROR_MESSAGE", "", "ASCII_PATTERN", "CUSTOM_ERROR_MESSAGE", "IDEA_ERROR_MESSAGE", "IDEA_PATTERN", "errorMessages", "", "ktlint-ruleset-standard"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

