/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard.internal.importordering;

import com.pinterest.ktlint.ruleset.standard.internal.importordering.ImportLayoutParserKt;
import com.pinterest.ktlint.ruleset.standard.internal.importordering.ImportSorter;
import com.pinterest.ktlint.ruleset.standard.internal.importordering.PatternEntry;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/internal/importordering/ImportSorter;", "Ljava/util/Comparator;", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "Lkotlin/Comparator;", "importsLayout", "", "(Ljava/lang/String;)V", "patterns", "", "Lcom/pinterest/ktlint/ruleset/standard/internal/importordering/PatternEntry;", "getPatterns", "()Ljava/util/List;", "compare", "", "import1", "import2", "findImportIndex", "path", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "ktlint-ruleset-standard"})
public final class ImportSorter
implements Comparator<KtImportDirective> {
    @NotNull
    private final List<PatternEntry> patterns;

    @NotNull
    public final List<PatternEntry> getPatterns() {
        return this.patterns;
    }

    @Override
    public int compare(@NotNull KtImportDirective import1, @NotNull KtImportDirective import2) {
        Intrinsics.checkParameterIsNotNull((Object)import1, (String)"import1");
        Intrinsics.checkParameterIsNotNull((Object)import2, (String)"import2");
        ImportPath importPath = import1.getImportPath();
        if (importPath == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)importPath, (String)"import1.importPath!!");
        ImportPath importPath1 = importPath;
        ImportPath importPath2 = import2.getImportPath();
        if (importPath2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)importPath2, (String)"import2.importPath!!");
        ImportPath importPath22 = importPath2;
        return ComparisonsKt.compareValuesBy((Object)importPath1, (Object)importPath22, (Function1[])new Function1[]{(Function1)new Function1<ImportPath, Integer>(this){
            final /* synthetic */ ImportSorter this$0;

            public final int invoke(@NotNull ImportPath importPath) {
                Intrinsics.checkParameterIsNotNull((Object)importPath, (String)"import");
                return this.this$0.findImportIndex(importPath);
            }
            {
                this.this$0 = importSorter;
                super(1);
            }
        }, compare.2.INSTANCE});
    }

    /*
     * WARNING - void declaration
     */
    public final int findImportIndex(@NotNull ImportPath path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        int bestIndex = -1;
        PatternEntry bestEntryMatch = null;
        int allOtherAliasIndex = -1;
        int allOtherIndex = -1;
        boolean bl = false;
        for (PatternEntry entry : (Iterable)this.patterns) {
            void index;
            if (Intrinsics.areEqual((Object)entry, (Object)PatternEntry.Companion.getALL_OTHER_ALIAS_IMPORTS_ENTRY())) {
                allOtherAliasIndex = index;
            }
            if (Intrinsics.areEqual((Object)entry, (Object)PatternEntry.Companion.getALL_OTHER_IMPORTS_ENTRY())) {
                allOtherIndex = index;
            }
            if (entry.isBetterMatchForPackageThan(bestEntryMatch, path)) {
                bestEntryMatch = entry;
                bestIndex = index;
            }
            ++index;
        }
        if (bestIndex == -1 && path.hasAlias() && allOtherAliasIndex == -1 && allOtherIndex != -1) {
            bestIndex = allOtherIndex;
        }
        return bestIndex;
    }

    public ImportSorter(@NotNull String importsLayout) {
        Intrinsics.checkParameterIsNotNull((Object)importsLayout, (String)"importsLayout");
        this.patterns = ImportLayoutParserKt.parseImportsLayout(importsLayout);
    }
}

