/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.webclient.client;

import feign.MethodMetadata;
import feign.Util;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.function.BiFunction;
import org.reactivestreams.Publisher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import reactivefeign.client.ReactiveFeignException;
import reactivefeign.client.ReactiveHttpClient;
import reactivefeign.client.ReactiveHttpRequest;
import reactivefeign.client.ReactiveHttpResponse;
import reactivefeign.client.ReadTimeoutException;
import reactivefeign.utils.FeignUtils;
import reactivefeign.webclient.client.WebReactiveHttpEntityResponse;
import reactivefeign.webclient.client.WebReactiveHttpResponse;
import reactor.core.publisher.Mono;

public class WebReactiveHttpClient<P extends Publisher<?>>
implements ReactiveHttpClient<P> {
    private final WebClient webClient;
    private final ParameterizedTypeReference<Object> bodyActualType;
    private final BiFunction<ReactiveHttpRequest, ClientResponse, ReactiveHttpResponse<P>> responseFunction;

    public static <P extends Publisher<?>> WebReactiveHttpClient<P> webClient(MethodMetadata methodMetadata, WebClient webClient) {
        Class returnPublisherType = FeignUtils.returnPublisherType((MethodMetadata)methodMetadata);
        ParameterizedTypeReference returnActualType = ParameterizedTypeReference.forType((Type)FeignUtils.returnActualType((MethodMetadata)methodMetadata));
        ParameterizedTypeReference bodyActualType = Optional.ofNullable(FeignUtils.getBodyActualType((Type)methodMetadata.bodyType())).map(ParameterizedTypeReference::forType).orElse(null);
        if (returnActualType.getType() instanceof ParameterizedType && ((ParameterizedType)returnActualType.getType()).getRawType().equals(ResponseEntity.class)) {
            Type entityType = Util.resolveLastTypeParameter((Type)returnActualType.getType(), ResponseEntity.class);
            Class entityPublisherType = FeignUtils.returnPublisherType((Type)entityType);
            ParameterizedTypeReference entityActualType = ParameterizedTypeReference.forType((Type)FeignUtils.returnActualType((Type)entityType));
            return new WebReactiveHttpClient<P>(webClient, (ParameterizedTypeReference<Object>)bodyActualType, (request, response) -> new WebReactiveHttpEntityResponse((ReactiveHttpRequest)request, (ClientResponse)response, entityPublisherType, (ParameterizedTypeReference<?>)entityActualType));
        }
        return new WebReactiveHttpClient<P>(webClient, (ParameterizedTypeReference<Object>)bodyActualType, WebReactiveHttpClient.webReactiveHttpResponse(returnPublisherType, returnActualType));
    }

    public static <P extends Publisher<?>> BiFunction<ReactiveHttpRequest, ClientResponse, ReactiveHttpResponse<P>> webReactiveHttpResponse(Type returnPublisherType, ParameterizedTypeReference<?> returnActualType) {
        return (request, response) -> new WebReactiveHttpResponse((ReactiveHttpRequest)request, (ClientResponse)response, returnPublisherType, returnActualType);
    }

    public WebReactiveHttpClient(WebClient webClient, ParameterizedTypeReference<Object> bodyActualType, BiFunction<ReactiveHttpRequest, ClientResponse, ReactiveHttpResponse<P>> responseFunction) {
        this.webClient = webClient;
        this.bodyActualType = bodyActualType;
        this.responseFunction = responseFunction;
    }

    public Mono<ReactiveHttpResponse<P>> executeRequest(ReactiveHttpRequest request) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.method(HttpMethod.valueOf((String)request.method())).uri(request.uri())).headers(httpHeaders -> this.setUpHeaders(request, (HttpHeaders)httpHeaders))).body(this.provideBody(request)).exchange().onErrorMap(ex -> {
            if (ex instanceof io.netty.handler.timeout.ReadTimeoutException) {
                return new ReadTimeoutException(ex, request);
            }
            return new ReactiveFeignException(ex, request);
        }).map(response -> this.toReactiveHttpResponse(request, (ClientResponse)response));
    }

    protected ReactiveHttpResponse<P> toReactiveHttpResponse(ReactiveHttpRequest request, ClientResponse response) {
        return this.responseFunction.apply(request, response);
    }

    protected BodyInserter<?, ? super ClientHttpRequest> provideBody(ReactiveHttpRequest request) {
        return this.bodyActualType != null ? BodyInserters.fromPublisher((Publisher)request.body(), this.bodyActualType) : BodyInserters.empty();
    }

    protected void setUpHeaders(ReactiveHttpRequest request, HttpHeaders httpHeaders) {
        request.headers().forEach((arg_0, arg_1) -> ((HttpHeaders)httpHeaders).put(arg_0, arg_1));
    }
}

