/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.webclient;

import feign.MethodMetadata;
import io.netty.handler.timeout.ReadTimeoutException;
import java.util.function.BiFunction;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientRequestException;
import reactivefeign.ReactiveFeign;
import reactivefeign.ReactiveOptions;
import reactivefeign.client.ReactiveHttpRequest;
import reactivefeign.webclient.CustomizableWebClientBuilder;
import reactivefeign.webclient.NettyClientHttpConnectorBuilder;
import reactivefeign.webclient.WebClientFeignCustomizer;
import reactivefeign.webclient.WebReactiveOptions;
import reactivefeign.webclient.client.WebReactiveHttpClient;

public class WebReactiveFeign {
    public static <T> Builder<T> builder() {
        return WebReactiveFeign.builder(WebClient.builder());
    }

    public static <T> Builder<T> builder(WebClient.Builder webClientBuilder) {
        return new Builder(webClientBuilder);
    }

    public static <T> Builder<T> builder(WebClient.Builder webClientBuilder, WebClientFeignCustomizer webClientCustomizer) {
        return new Builder(webClientBuilder, webClientCustomizer);
    }

    public static class Builder<T>
    extends ReactiveFeign.Builder<T> {
        protected CustomizableWebClientBuilder webClientBuilder;

        protected Builder(WebClient.Builder webClientBuilder) {
            this.webClientBuilder = new CustomizableWebClientBuilder(webClientBuilder);
            this.webClientBuilder.clientConnector(NettyClientHttpConnectorBuilder.buildNettyClientHttpConnector(WebReactiveOptions.DEFAULT_OPTIONS));
            this.updateClientFactory();
        }

        protected Builder(WebClient.Builder webClientBuilder, WebClientFeignCustomizer webClientCustomizer) {
            this.webClientBuilder = new CustomizableWebClientBuilder(webClientBuilder);
            this.webClientBuilder.clientConnector(NettyClientHttpConnectorBuilder.buildNettyClientHttpConnector(WebReactiveOptions.DEFAULT_OPTIONS));
            webClientCustomizer.accept((Object)this.webClientBuilder);
            this.updateClientFactory();
        }

        public Builder<T> options(ReactiveOptions options) {
            this.webClientBuilder.clientConnector(NettyClientHttpConnectorBuilder.buildNettyClientHttpConnector((WebReactiveOptions)options));
            this.updateClientFactory();
            return this;
        }

        protected void updateClientFactory() {
            this.clientFactory(methodMetadata -> WebReactiveHttpClient.webClient((MethodMetadata)methodMetadata, (WebClient)this.webClientBuilder.build(), Builder.errorMapper()));
        }

        public static BiFunction<ReactiveHttpRequest, Throwable, Throwable> errorMapper() {
            return (request, throwable) -> {
                if (throwable instanceof WebClientRequestException && throwable.getCause() instanceof ReadTimeoutException) {
                    return new reactivefeign.client.ReadTimeoutException(throwable, request);
                }
                return null;
            };
        }
    }
}

