/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.rabbitmq;

import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.rabbitmq.RabbitMQProperties;
import com.playtika.test.rabbitmq.RabbitMQStatusCheck;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;

@Configuration
@Order(value=-2147483648)
@ConditionalOnProperty(name={"embedded.rabbitmq.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={RabbitMQProperties.class})
public class EmbeddedRabbitMQBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedRabbitMQBootstrapConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public RabbitMQStatusCheck rabbitMQStartupCheckStrategy(RabbitMQProperties properties) {
        return new RabbitMQStatusCheck(properties);
    }

    @Bean(name={"embeddedRabbitMq"}, destroyMethod="stop")
    public GenericContainer rabbitmq(ConfigurableEnvironment environment, RabbitMQProperties properties, RabbitMQStatusCheck rabbitMQStatusCheck) {
        log.info("Starting rabbitMQ server. Docker image: {}", (Object)properties.getDockerImage());
        GenericContainer rabbitMQ = new GenericContainer(properties.getDockerImage()).withEnv("RABBITMQ_DEFAULT_VHOST", properties.getVhost()).withEnv("RABBITMQ_DEFAULT_USER", properties.getUser()).withEnv("RABBITMQ_DEFAULT_PASS", properties.getPassword()).withLogConsumer(ContainerUtils.containerLogsConsumer((Logger)log)).withExposedPorts(new Integer[]{properties.getPort()}).withStartupTimeout(properties.getTimeoutDuration());
        rabbitMQ.start();
        this.registerRabbitMQEnvironment(rabbitMQ, environment, properties);
        return rabbitMQ;
    }

    private void registerRabbitMQEnvironment(GenericContainer rabbitMQ, ConfigurableEnvironment environment, RabbitMQProperties properties) {
        Integer mappedPort = rabbitMQ.getMappedPort(properties.getPort());
        String host = rabbitMQ.getContainerIpAddress();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.rabbitmq.port", mappedPort);
        map.put("embedded.rabbitmq.host", host);
        map.put("embedded.rabbitmq.vhost", properties.getVhost());
        map.put("embedded.rabbitmq.user", properties.getUser());
        map.put("embedded.rabbitmq.password", properties.getPassword());
        log.info("Started RabbitMQ server. Connection details: {}", map);
        MapPropertySource propertySource = new MapPropertySource("embeddedRabbitMqInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

