/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.io;

import com.prowidesoftware.swift.io.parser.SwiftParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReader
implements Iterator<String>,
Iterable<String> {
    private static final Logger log = Logger.getLogger(AbstractReader.class.getName());
    protected Reader reader = null;

    public AbstractReader(Reader r) {
        this.reader = r;
    }

    public AbstractReader(String string) {
        Validate.notNull((Object)string, (String)"string must not be null");
        this.reader = new StringReader(string);
    }

    public AbstractReader(InputStream stream) {
        Validate.notNull((Object)stream, (String)"stream must not be null");
        this.reader = new InputStreamReader(stream);
    }

    public AbstractReader(File file) throws FileNotFoundException {
        Validate.notNull((Object)file, (String)"file must not be null");
        Validate.isTrue((boolean)file.exists(), (String)("Non existent file: " + file.getAbsolutePath()));
        this.reader = new FileReader(file);
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }

    @Override
    public abstract String next();

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove not avaiable in this implementation");
    }

    public AbstractMT nextMT() throws IOException {
        SwiftMessage candidate = this.nextSwiftMessage();
        if (candidate != null) {
            if (candidate.isServiceMessage21()) {
                String fin = candidate.getUnparsedTexts().getAsFINString();
                SwiftParser parser = new SwiftParser(new ByteArrayInputStream(fin.getBytes()));
                return parser.message().toMT();
            }
            if (candidate.isServiceMessage()) {
                log.warning("nextMT in " + this.getClass().getName() + " is not intended for service messages, use nextSwiftMessage() instead");
                return null;
            }
            return candidate.toMT();
        }
        return null;
    }

    public SwiftMessage nextSwiftMessage() throws IOException {
        String msg = this.next();
        if (StringUtils.isNotBlank((String)msg)) {
            SwiftParser parser = new SwiftParser(new ByteArrayInputStream(msg.getBytes()));
            return parser.message();
        }
        log.warning("Ignoring blank message");
        return null;
    }
}

