/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.io.parser;

import com.prowidesoftware.swift.model.MxNode;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

final class MxNodeContentHandler
implements ContentHandler {
    private static final transient Logger log = Logger.getLogger(MxNodeContentHandler.class.getName());
    private MxNode currentNode;
    private MxNode rootNode;

    MxNodeContentHandler() {
    }

    MxNode getRootNode() {
        return this.rootNode;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
        this.currentNode = null;
    }

    public void endDocument() throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("uri: " + uri + "\nlocalName: " + localName + "\nqName: " + qName + (atts == null ? "" : "\natts(" + atts.getLength() + "): ..."));
        }
        MxNode node = new MxNode(this.currentNode, localName);
        if (atts != null) {
            for (int i = 0; i < atts.getLength(); ++i) {
                node.addAttribute(atts.getLocalName(i), atts.getValue(i));
            }
        }
        if (!(uri == null || node.getParent() != null && StringUtils.equals((String)node.getParent().getAttribute("xmlns"), (String)uri))) {
            node.addAttribute("xmlns", uri);
        }
        this.currentNode = node;
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        log.finest("end: " + localName);
        if (this.currentNode.getParent() == null) {
            this.rootNode = this.currentNode;
        }
        this.currentNode = this.currentNode.getParent();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String v = new String(ch, start, length);
        log.finest("characters: " + v);
        this.currentNode.setValue(v);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
        log.finer("skippedEntity: " + name);
    }
}

