/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.swift.model.FileFormat;
import com.prowidesoftware.swift.model.MessageIOType;
import com.prowidesoftware.swift.model.MessageStandardType;
import com.prowidesoftware.swift.model.SwiftMessageNote;
import com.prowidesoftware.swift.model.SwiftMessageRevision;
import com.prowidesoftware.swift.model.SwiftMessageStatusInfo;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSwiftMessage
implements Serializable {
    private static final transient Logger log = Logger.getLogger(AbstractSwiftMessage.class.getName());
    private static final long serialVersionUID = 3769865560736793606L;
    protected static final String IDENTIFIER_ACK = "ACK";
    protected static final String IDENTIFIER_NAK = "NAK";
    private Long id;
    private String message;
    protected String identifier;
    protected String sender;
    protected String receiver;
    private MessageIOType direction;
    private String checksum;
    private Calendar lastModified = Calendar.getInstance();
    private Calendar creationDate = Calendar.getInstance();
    private List<SwiftMessageStatusInfo> statusTrail = new ArrayList<SwiftMessageStatusInfo>();
    private String status;
    private List<SwiftMessageNote> notes = new ArrayList<SwiftMessageNote>();
    private Map<String, String> properties = new HashMap<String, String>();
    private String filename;
    private FileFormat fileFormat;
    private String reference;
    private String currency;
    private BigDecimal amount;
    private List<SwiftMessageRevision> revisions = new ArrayList<SwiftMessageRevision>();
    public static final transient String PROPERTY_NAME = "name";

    public AbstractSwiftMessage() {
    }

    protected AbstractSwiftMessage(String content) {
        this.message = content;
        this.updateFromMessage();
    }

    protected AbstractSwiftMessage(String content, FileFormat fileFormat) {
        this.message = content;
        this.fileFormat = fileFormat;
        this.updateFromMessage();
    }

    protected AbstractSwiftMessage(InputStream stream) throws IOException {
        this.message = Lib.readStream(stream);
        this.updateFromMessage();
    }

    protected AbstractSwiftMessage(InputStream stream, FileFormat fileFormat) throws IOException {
        this.message = Lib.readStream(stream);
        this.fileFormat = fileFormat;
        this.updateFromMessage();
    }

    protected AbstractSwiftMessage(File file) throws IOException {
        this.message = Lib.readFile(file);
        this.filename = file.getAbsolutePath();
        this.updateFromMessage();
    }

    protected AbstractSwiftMessage(File file, FileFormat fileFormat) throws IOException {
        this.message = Lib.readFile(file);
        this.filename = file.getAbsolutePath();
        this.fileFormat = fileFormat;
        this.updateFromMessage();
    }

    protected abstract void updateFromMessage();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getMessage() {
        return this.message;
    }

    public String message() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    @XmlTransient
    public Calendar getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Calendar lastModified) {
        this.lastModified = lastModified;
    }

    @XmlTransient
    public Calendar getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Calendar creationDate) {
        this.creationDate = creationDate;
    }

    public List<SwiftMessageNote> getNotes() {
        return this.notes;
    }

    public void setNotes(List<SwiftMessageNote> notes) {
        this.notes = notes;
    }

    @XmlTransient
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public List<SwiftMessageStatusInfo> getStatusTrail() {
        return this.statusTrail;
    }

    public void setStatusTrail(List<SwiftMessageStatusInfo> statusTrail) {
        this.statusTrail = statusTrail;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public String getReceiver() {
        return this.receiver;
    }

    public void setReceiver(String receiver) {
        this.receiver = receiver;
    }

    public MessageIOType getDirection() {
        return this.direction;
    }

    public void setDirection(MessageIOType direction) {
        this.direction = direction;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getMessageName() {
        Map<String, String> p = this.getProperties();
        if (p != null && p.containsKey(PROPERTY_NAME) && StringUtils.isNotBlank((String)p.get(PROPERTY_NAME))) {
            return p.get(PROPERTY_NAME);
        }
        return null;
    }

    public void addStatus(SwiftMessageStatusInfo status) {
        if (status != null) {
            if (this.getStatusTrail() == null) {
                this.setStatusTrail(new ArrayList<SwiftMessageStatusInfo>());
            }
            this.statusTrail.add(status);
            this.setStatus(status.getName());
        }
    }

    public boolean isOutgoing() {
        return this.direction == MessageIOType.outgoing;
    }

    public boolean isInput() {
        return this.isOutgoing();
    }

    public Boolean isIncoming() {
        return this.direction == MessageIOType.incoming;
    }

    public Boolean isOutput() {
        return this.isIncoming();
    }

    public void setStatus(SwiftMessageStatusInfo status) {
        this.addStatus(status);
    }

    public boolean isStatus(String status) {
        return StringUtils.equals((String)status, (String)this.getStatus());
    }

    public boolean isStatus(Enum status) {
        if (status != null) {
            return this.isStatus(status.name());
        }
        return false;
    }

    public SwiftMessageStatusInfo getStatusInfo() {
        List<SwiftMessageStatusInfo> l = this.getStatusTrail();
        if (l != null && !l.isEmpty()) {
            return l.get(l.size() - 1);
        }
        return null;
    }

    public SwiftMessageStatusInfo getPreviousStatusInfo() {
        List<SwiftMessageStatusInfo> l = this.getStatusTrail();
        if (l != null && !l.isEmpty()) {
            return l.get(l.size() - 2);
        }
        return null;
    }

    public boolean contains(Enum ... statuses) {
        boolean result = false;
        List<SwiftMessageStatusInfo> l = this.getStatusTrail();
        if (l != null && !l.isEmpty()) {
            for (SwiftMessageStatusInfo s : this.getStatusTrail()) {
                for (Enum e : statuses) {
                    if (e == null || !StringUtils.equals((String)s.getName(), (String)e.name())) continue;
                    result = true;
                }
            }
        }
        return result;
    }

    public boolean contains(String ... statuses) {
        boolean result = false;
        List<SwiftMessageStatusInfo> l = this.getStatusTrail();
        if (l != null && !l.isEmpty()) {
            for (SwiftMessageStatusInfo s : this.getStatusTrail()) {
                for (String e : statuses) {
                    if (e == null || !StringUtils.equals((String)s.getName(), (String)e)) continue;
                    result = true;
                }
            }
        }
        return result;
    }

    public boolean isStatus(String ... statuses) {
        for (String s : statuses) {
            if (!this.isStatus(s)) continue;
            return true;
        }
        return false;
    }

    public boolean isStatus(Enum ... statuses) {
        for (Enum e : statuses) {
            if (e == null || !this.isStatus(e.name())) continue;
            return true;
        }
        return false;
    }

    public String getLastData(String ... statuses) {
        List<SwiftMessageStatusInfo> l = this.getStatusTrail();
        if (l != null && !l.isEmpty()) {
            for (int i = l.size() - 1; i >= 0; --i) {
                String d = l.get(i).getData();
                if (d == null || statuses != null && !ArrayUtils.contains((Object[])statuses, (Object)l.get(i).getName())) continue;
                return d;
            }
        }
        return "";
    }

    public String getLastData() {
        return this.getLastData(null);
    }

    public SwiftMessageStatusInfo findStatusInfo(String ... statusNames) {
        List<SwiftMessageStatusInfo> l = this.getStatusTrail();
        if (l != null && !l.isEmpty()) {
            for (SwiftMessageStatusInfo sms : l) {
                if (!ArrayUtils.contains((Object[])statusNames, (Object)sms.getName())) continue;
                return sms;
            }
        }
        return null;
    }

    public SwiftMessageStatusInfo findStatusInfo(String statusName) {
        String[] statuses = new String[]{statusName};
        return this.findStatusInfo(statuses);
    }

    public SwiftMessageStatusInfo findStatusInfoLast(String ... statusNames) {
        List<SwiftMessageStatusInfo> l = this.getStatusTrail();
        if (l != null && !l.isEmpty()) {
            for (int i = l.size() - 1; i >= 0; --i) {
                if (!ArrayUtils.contains((Object[])statusNames, (Object)l.get(i).getName())) continue;
                return l.get(i);
            }
        }
        return null;
    }

    public SwiftMessageStatusInfo findStatusInfoLast(String statusName) {
        String[] statuses = new String[]{statusName};
        return this.findStatusInfoLast(statuses);
    }

    public void addNote(SwiftMessageNote n) {
        if (this.notes == null) {
            this.notes = new ArrayList<SwiftMessageNote>();
        }
        this.notes.add(n);
    }

    public void sanityCheckProperties() {
        try {
            Map<String, String> p = this.getProperties();
            for (Map.Entry<String, String> entry : p.entrySet()) {
                String v = entry.getValue();
                if (v != null && v.length() > 500) {
                    log.severe("Value for key=" + entry.getKey() + " too long, will be truncated. value=" + v);
                    p.put(entry.getKey(), v.substring(0, 500));
                }
                if (entry.getKey().length() <= 200) continue;
                log.severe("Key too long: " + entry.getKey() + " will be truncated");
                p.remove(entry.getKey());
                p.put(entry.getKey().substring(0, 200), v);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error cheking properties", e);
        }
    }

    public String getProperty(String key) {
        Map<String, String> p = this.getProperties();
        if (p != null && p.containsKey(key) && StringUtils.isNotBlank((String)p.get(key))) {
            return p.get(key);
        }
        return null;
    }

    public String getProperty(Enum key) {
        return this.getProperty(key.name());
    }

    public void setProperty(String key, String value) {
        if (this.getProperties() == null) {
            this.setProperties(new HashMap<String, String>());
        }
        if (StringUtils.isNotBlank((String)value)) {
            this.getProperties().put(key, value);
        }
    }

    public void setProperty(Enum key, String value) {
        this.setProperty(key.name(), value);
    }

    public boolean getPropertyBoolean(String key) {
        return StringUtils.equals((String)"true", (String)this.getProperty(key));
    }

    public boolean getPropertyBoolean(Enum key) {
        return this.getPropertyBoolean(key.name());
    }

    public String getPaddedId() {
        String id = this.id != null ? this.id.toString() : "0";
        return StringUtils.leftPad((String)id, (int)10, (String)"0");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.checksum == null ? 0 : this.checksum.hashCode());
        result = 31 * result + (this.creationDate == null ? 0 : this.creationDate.hashCode());
        result = 31 * result + (this.direction == null ? 0 : this.direction.hashCode());
        result = 31 * result + (this.filename == null ? 0 : this.filename.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
        result = 31 * result + (this.lastModified == null ? 0 : this.lastModified.hashCode());
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.notes == null ? 0 : ((Object)this.notes).hashCode());
        result = 31 * result + (this.properties == null ? 0 : ((Object)this.properties).hashCode());
        result = 31 * result + (this.receiver == null ? 0 : this.receiver.hashCode());
        result = 31 * result + (this.revisions == null ? 0 : ((Object)this.revisions).hashCode());
        result = 31 * result + (this.sender == null ? 0 : this.sender.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.statusTrail == null ? 0 : ((Object)this.statusTrail).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractSwiftMessage other = (AbstractSwiftMessage)obj;
        if (this.checksum == null ? other.checksum != null : !this.checksum.equals(other.checksum)) {
            return false;
        }
        if (this.creationDate == null ? other.creationDate != null : !this.creationDate.equals(other.creationDate)) {
            return false;
        }
        if (this.direction != other.direction) {
            return false;
        }
        if (this.filename == null ? other.filename != null : !this.filename.equals(other.filename)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.identifier == null ? other.identifier != null : !this.identifier.equals(other.identifier)) {
            return false;
        }
        if (this.lastModified == null ? other.lastModified != null : !this.lastModified.equals(other.lastModified)) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        if (this.notes == null ? other.notes != null : !((Object)this.notes).equals(other.notes)) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !((Object)this.properties).equals(other.properties)) {
            return false;
        }
        if (this.receiver == null ? other.receiver != null : !this.receiver.equals(other.receiver)) {
            return false;
        }
        if (this.revisions == null ? other.revisions != null : !((Object)this.revisions).equals(other.revisions)) {
            return false;
        }
        if (this.sender == null ? other.sender != null : !this.sender.equals(other.sender)) {
            return false;
        }
        if (this.status == null ? other.status != null : !this.status.equals(other.status)) {
            return false;
        }
        return !(this.statusTrail == null ? other.statusTrail != null : !((Object)this.statusTrail).equals(other.statusTrail));
    }

    @Deprecated
    public abstract AbstractSwiftMessage readFile(File var1) throws IOException;

    public void copyTo(AbstractSwiftMessage msg) {
        msg.setChecksum(this.getChecksum());
        msg.setCreationDate(this.getCreationDate());
        msg.setDirection(this.getDirection());
        msg.setFilename(this.getFilename());
        msg.setId(this.getId());
        msg.setIdentifier(this.getIdentifier());
        msg.setLastModified(this.getLastModified());
        msg.setMessage(this.getMessage());
        msg.setNotes(this.getNotes());
        msg.setProperties(this.getProperties());
        msg.setReceiver(this.getReceiver());
        msg.setSender(this.getSender());
        msg.setStatus(this.getStatus());
        msg.setStatusTrail(this.getStatusTrail());
    }

    public List<SwiftMessageRevision> getRevisions() {
        return this.revisions;
    }

    public void setRevisions(List<SwiftMessageRevision> revisions) {
        this.revisions = revisions;
    }

    public void addRevision(SwiftMessageRevision revision) {
        if (this.revisions == null) {
            this.revisions = new ArrayList<SwiftMessageRevision>();
        }
        this.revisions.add(revision);
    }

    public SwiftMessageRevision createRevision() {
        SwiftMessageRevision rev = new SwiftMessageRevision(this);
        this.addRevision(rev);
        return rev;
    }

    public boolean isMT() {
        return this.getClass().getSimpleName().startsWith("Mt");
    }

    public boolean isMX() {
        return this.getClass().getSimpleName().startsWith("Mx");
    }

    public MessageStandardType messageStandardType() {
        if (this.isMT()) {
            return MessageStandardType.MT;
        }
        if (this.isMX()) {
            return MessageStandardType.MX;
        }
        return null;
    }

    public FileFormat getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(FileFormat fileFormat) {
        this.fileFormat = fileFormat;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public boolean match(String regex) {
        return this.identifier != null && StringUtils.isNotBlank((String)regex) && this.identifier.matches(regex);
    }

    public String formattedAmount() {
        return this.formattedAmount(null, true);
    }

    public String formattedAmount(Locale locale, boolean includeCurrency) {
        StringBuilder result = new StringBuilder();
        if (this.amount != null) {
            if (includeCurrency && this.currency != null) {
                result.append(this.currency);
                result.append(" ");
            }
            NumberFormat formatter = locale != null ? NumberFormat.getInstance(locale) : NumberFormat.getInstance();
            result.append(formatter.format(this.amount));
        }
        return result.toString();
    }

    public boolean identifiedAsACK() {
        return StringUtils.equals((String)this.identifier, (String)IDENTIFIER_ACK);
    }

    public boolean identifiedAsNAK() {
        return StringUtils.equals((String)this.identifier, (String)IDENTIFIER_NAK);
    }
}

