/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MessageIOType {
    incoming,
    outgoing,
    both;


    public static boolean isValid(String ioType) {
        Validate.notNull((Object)ioType, (String)"ioType can not be null");
        for (MessageIOType t : MessageIOType.values()) {
            if (!StringUtils.equals((String)ioType.trim(), (String)t.name())) continue;
            return true;
        }
        return false;
    }

    public boolean isIncoming() {
        return this == incoming;
    }

    public boolean isOutgoing() {
        return this == outgoing;
    }

    public boolean isBoth() {
        return this == both;
    }
}

