/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.swift.model.SwiftBlock2Field;
import com.prowidesoftware.swift.model.SwiftBlock2Input;
import com.prowidesoftware.swift.model.SwiftBlock2Output;
import com.prowidesoftware.swift.model.SwiftValueBlock;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public abstract class SwiftBlock2
extends SwiftValueBlock
implements Serializable {
    private static final transient Logger log = Logger.getLogger(SwiftBlock2.class.getName());
    private static final long serialVersionUID = 7994472954593732477L;
    protected String messagePriority = "N";
    protected String messageType = null;

    protected void setBlockNumber(Integer blockNumber) {
        Validate.notNull((Object)blockNumber, (String)"parameter 'blockNumber' cannot be null");
        Validate.isTrue((blockNumber == 2 ? 1 : 0) != 0, (String)"blockNumber must be 2");
    }

    protected void setBlockName(String blockName) {
        Validate.notNull((Object)blockName, (String)"parameter 'blockName' cannot be null");
        Validate.isTrue((blockName.compareTo("2") == 0 ? 1 : 0) != 0, (String)"blockName must be string '2'");
    }

    public Integer getNumber() {
        return 2;
    }

    public String getName() {
        return "2";
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessagePriority(String messagePriority) {
        this.messagePriority = messagePriority;
    }

    public String getMessagePriority() {
        return this.messagePriority;
    }

    public MessagePriority getMessagePriorityType() {
        if (this.messagePriority != null) {
            try {
                return MessagePriority.valueOf(this.messagePriority);
            }
            catch (Exception e) {
                String text = "Block2 messagePriority contains an invalid value [" + this.messagePriority + "]. The expected values are " + MessagePriority.values();
                log.warning(text);
                log.log(Level.FINEST, text, e);
            }
        }
        return null;
    }

    public boolean isInput() {
        return this instanceof SwiftBlock2Input;
    }

    public boolean isOutput() {
        return this instanceof SwiftBlock2Output;
    }

    public void clean() {
        this.messagePriority = null;
        this.messageType = null;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.messagePriority == null ? 0 : this.messagePriority.hashCode());
        result = 31 * result + (this.messageType == null ? 0 : this.messageType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SwiftBlock2 other = (SwiftBlock2)obj;
        if (this.messagePriority == null ? other.messagePriority != null : !this.messagePriority.equals(other.messagePriority)) {
            return false;
        }
        return !(this.messageType == null ? other.messageType != null : !this.messageType.equals(other.messageType));
    }

    public String toJson() {
        return null;
    }

    public String field(SwiftBlock2Field field) {
        switch (field) {
            case MessageType: {
                return this.getMessageType();
            }
            case MessagePriority: {
                return this.getMessagePriority();
            }
        }
        return null;
    }

    public void setField(SwiftBlock2Field field, String value) {
        switch (field) {
            case MessageType: {
                this.setMessageType(value);
                break;
            }
            case MessagePriority: {
                this.setMessagePriority(value);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MessagePriority {
        S("System"),
        N("Normal"),
        U("Urgent");

        private String label;

        private MessagePriority(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

