/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwiftBlock4
extends SwiftTagListBlock
implements Serializable {
    private static final long serialVersionUID = -623730182521597955L;

    public SwiftBlock4() {
    }

    public SwiftBlock4(List<Tag> tags) {
        Validate.notNull(tags, (String)"parameter 'tags' cannot be null");
        Validate.allElementsOfType(tags, Tag.class, (String)"parameter 'tags' may only have Tag elements");
        this.addTags(tags);
    }

    @Override
    protected void setBlockNumber(Integer blockNumber) {
        Validate.notNull((Object)blockNumber, (String)"parameter 'blockNumber' cannot be null");
        Validate.isTrue((blockNumber == 4 ? 1 : 0) != 0, (String)"blockNumber must be 4");
    }

    @Override
    protected void setBlockName(String blockName) {
        Validate.notNull((Object)blockName, (String)"parameter 'blockName' cannot be null");
        Validate.isTrue((blockName.compareTo("4") == 0 ? 1 : 0) != 0, (String)"blockName must be string '4'");
    }

    @Override
    public Integer getNumber() {
        return 4;
    }

    @Override
    public String getName() {
        return "4";
    }

    public static SwiftBlock4 removeEmptySequences(SwiftBlock4 b4) {
        if (b4 == null) {
            return null;
        }
        Stack<Tag> stack = new Stack<Tag>();
        for (Tag t : b4.getTags()) {
            if (!stack.isEmpty() && StringUtils.equals((String)t.getName(), (String)"16S") && StringUtils.equals((String)((Tag)stack.peek()).getName(), (String)"16R") && StringUtils.equals((String)((Tag)stack.peek()).getValue(), (String)t.getValue())) {
                stack.pop();
                continue;
            }
            if (t.isNumber(15) && ((Tag)stack.peek()).isNumber(15)) {
                stack.pop();
                stack.push(t);
                continue;
            }
            stack.push(t);
        }
        if (!stack.isEmpty() && ((Tag)stack.peek()).isNumber(15)) {
            stack.pop();
        }
        return new SwiftBlock4(new ArrayList<Tag>(stack));
    }
}

