/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.SwiftBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.TagVisitor;
import com.prowidesoftware.swift.model.field.Field;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwiftTagListBlock
extends SwiftBlock
implements Serializable,
Iterable<Tag> {
    private static final long serialVersionUID = -3753513588165638610L;
    private static final transient Logger log = Logger.getLogger(SwiftTagListBlock.class.getName());
    public static final SwiftTagListBlock EMPTY_LIST = SwiftTagListBlock.emptyList();
    private List<Tag> tags = new ArrayList<Tag>();

    public SwiftTagListBlock() {
    }

    public SwiftTagListBlock(List<Tag> tags) {
        this();
        this.tags = tags;
    }

    private static SwiftTagListBlock emptyList() {
        List<Tag> tagList = Collections.emptyList();
        return new SwiftTagListBlock(tagList);
    }

    public boolean containsTag(String tagName) {
        Validate.notNull((Object)tagName, (String)"parameter 'tagName' cannot not be null");
        for (Tag t : this.tags) {
            if (t.getName() == null || !t.getName().equals(tagName)) continue;
            return true;
        }
        return false;
    }

    public String getTagValue(String key) {
        Validate.notNull((Object)key, (String)"parameter 'key' cannot not be null");
        Tag tag = this.getTagByName(key);
        return tag != null ? tag.getValue() : null;
    }

    public Tag getTagByName(String key) {
        Validate.notNull((Object)key, (String)"parameter 'key' cannot not be null");
        for (Tag f : this.tags) {
            if (f.getName() == null || !f.getName().equals(key)) continue;
            return f;
        }
        return null;
    }

    public Field getFieldByName(String fieldname, String being, String component2) {
        Validate.notNull((Object)fieldname, (String)"parameter 'fieldname' cannot not be null");
        for (Tag t : this.tags) {
            Field f;
            if (t.getName() == null || !t.getName().equals(fieldname) || !(f = t.getField()).is(being) || !StringUtils.equals((String)f.getComponent(2), (String)component2)) continue;
            return f;
        }
        return null;
    }

    public Tag getTagByName(String fieldname, String component1, String component2) {
        Validate.notNull((Object)fieldname, (String)"parameter 'fieldname' cannot not be null");
        for (Tag t : this.tags) {
            Field f;
            if (t.getName() == null || !t.getName().equals(fieldname) || (f = t.getField()) == null || !f.is(component1) || !StringUtils.equals((String)f.getComponent(2), (String)component2)) continue;
            return t;
        }
        return null;
    }

    public Field getFieldByName(String fieldname, String component1) {
        Validate.notNull((Object)fieldname, (String)"parameter 'fieldname' cannot not be null");
        for (Tag t : this.tags) {
            Field f;
            if (t.getName() == null || !t.getName().equals(fieldname) || (f = t.getField()) == null || !f.is(component1)) continue;
            return f;
        }
        return null;
    }

    public Field getFieldByName(String key) {
        Tag r = this.getTagByName(key);
        if (r != null) {
            return r.getField();
        }
        return null;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    @Deprecated
    public void addTag(Tag t) {
        DeprecationUtils.phase2(this.getClass(), "addTag(Tag)", "use append(Tag) instead.");
        Validate.notNull((Object)t, (String)"parameter 't' cannot not be null");
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Adding Tag [" + t + "]");
        }
        if (this.tags == null) {
            this.tags = new ArrayList<Tag>();
        }
        this.tags.add(t);
    }

    @Deprecated
    public void add(Field f) {
        DeprecationUtils.phase2(this.getClass(), "add(Field)", "use append(Field) instead.");
        this.append(new Tag(f.getName(), f.getValue()));
    }

    @Deprecated
    public int getTagCount(String key) {
        DeprecationUtils.phase2(this.getClass(), "getTagCount(String)", "Use countByName(String) instead.");
        return this.countByName(key);
    }

    public int countByName(String tagname) {
        Validate.notNull((Object)tagname, (String)"parameter 'tagname' cannot not be null");
        int count = 0;
        if (this.tags != null) {
            for (Tag f : this.tags) {
                if (!f.getName().equals(tagname)) continue;
                ++count;
            }
        }
        return count;
    }

    public String[] getTagValues(String key) {
        Validate.notNull((Object)key, (String)"parameter 'key' cannot not be null");
        ArrayList<String> ret = new ArrayList<String>();
        if (this.tags != null) {
            for (Tag f : this.tags) {
                if (!f.getName().equals(key)) continue;
                ret.add(f.getValue());
            }
        }
        return ret.toArray(new String[ret.size()]);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[" + (this.tags == null ? "tags=null" : this.tags.toString()) + "]";
    }

    public Map<String, String> getTagMap() {
        if (this.tags != null) {
            HashMap<String, String> m = new HashMap<String, String>(this.tags.size());
            for (Tag f : this.tags) {
                if (m.containsKey(f.getName())) continue;
                m.put(f.getName(), f.getValue());
            }
            return m;
        }
        return null;
    }

    public String removeTag(String tag) {
        Validate.notNull((Object)tag, (String)"parameter 'tag' cannot not be null");
        if (this.tags != null) {
            int i = 0;
            for (Tag t : this.tags) {
                if (t.getName() != null && t.getName().equals(tag)) {
                    Tag r = this.tags.remove(i);
                    return r.getValue();
                }
                ++i;
            }
        }
        return null;
    }

    public int removeAll(String name) {
        Validate.notNull((Object)name, (String)"parameter 'name' cannot not be null");
        int removed = 0;
        Tag[] matching = this.getTagsByName(name);
        for (int i = 0; i < matching.length; ++i) {
            this.tags.remove(matching[i]);
            ++removed;
        }
        return removed;
    }

    public Tag[] getTagsByName(String name) {
        Validate.notNull((Object)name, (String)"parameter 'name' cannot not be null");
        ArrayList<Tag> l = new ArrayList<Tag>();
        for (Tag t : this.tags) {
            if (t.getName() == null && name == null) {
                l.add(t);
            }
            if (t.getName() == null || name == null || !t.getName().equals(name)) continue;
            l.add(t);
        }
        return l.toArray(new Tag[l.size()]);
    }

    public Field[] getFieldsByName(String name) {
        String search;
        boolean wildcard;
        Validate.notNull((Object)name, (String)"parameter 'name' cannot not be null");
        if (name.endsWith("a")) {
            wildcard = true;
            search = name.substring(0, name.length() - 1);
        } else {
            wildcard = false;
            search = name;
        }
        ArrayList<Field> l = new ArrayList<Field>();
        for (Tag t : this.tags) {
            if ((!wildcard || !StringUtils.startsWith((String)t.getName(), (String)search)) && !StringUtils.equals((String)t.getName(), (String)name)) continue;
            Field field = t.getField();
            if (field == null) {
                log.warning("Could not create field instance of " + t);
                continue;
            }
            l.add(field);
        }
        return l.toArray(new Field[l.size()]);
    }

    public List<? extends Field> getFieldsByName(String name, String being) {
        String search;
        boolean wildcard;
        Validate.notNull((Object)name, (String)"parameter 'name' cannot not be null");
        Validate.notNull((Object)being, (String)"parameter 'being' cannot not be null");
        if (name.endsWith("a")) {
            wildcard = true;
            search = name.substring(0, name.length() - 1);
        } else {
            wildcard = false;
            search = name;
        }
        ArrayList<Field> l = new ArrayList<Field>();
        for (Tag t : this.tags) {
            if ((!wildcard || !StringUtils.startsWith((String)t.getName(), (String)search)) && !StringUtils.equals((String)t.getName(), (String)name)) continue;
            Field field = t.getField();
            if (field == null) {
                log.warning("Could not create field instance of " + t);
                continue;
            }
            if (!field.is(being)) continue;
            l.add(field);
        }
        return l;
    }

    public Iterator<Tag> tagIterator() {
        if (this.tags == null || this.tags.isEmpty()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("No tags in block, returning empty iterator");
            }
            return new EmptyItr();
        }
        return this.tags.iterator();
    }

    public Tag getTag(int i) {
        return this.tags.get(i);
    }

    public Field getField(int i) {
        return this.tags.get(i).getField();
    }

    public void addTags(List<Tag> tags) {
        Validate.notNull(tags, (String)"parameter 'tags' cannot not be null");
        Validate.allElementsOfType(tags, Tag.class, (String)"parameter 'tags' may only have Tag elements");
        this.thisTagsNotNull().addAll(tags);
    }

    private List<Tag> thisTagsNotNull() {
        if (this.tags == null) {
            this.tags = new ArrayList<Tag>();
        }
        return this.tags;
    }

    @Deprecated
    public int getTagCount() {
        return this.countAll();
    }

    public int countAll() {
        return this.tags == null ? 0 : this.tags.size();
    }

    public void setTags(List<Tag> tags) {
        if (tags != null) {
            Validate.allElementsOfType(tags, Tag.class, (String)"parameter 'tags' may only have Tag elements");
        }
        this.tags = tags;
    }

    public void setTags(Tag[] tags) {
        ArrayList<Tag> list = new ArrayList<Tag>();
        list.addAll(Arrays.asList(tags));
        this.setTags(list);
    }

    public boolean isEmpty() {
        return this.tags == null || this.tags.isEmpty();
    }

    public int size() {
        return this.tags == null ? 0 : this.tags.size();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.tags == null ? 0 : ((Object)this.tags).hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SwiftTagListBlock other = (SwiftTagListBlock)obj;
        return !(this.tags == null ? other.tags != null : !((Object)this.tags).equals(other.tags));
    }

    public boolean containsTag(int i) {
        if (this.tags == null || this.tags.isEmpty()) {
            return false;
        }
        for (Tag t : this.tags) {
            if (!t.isNumber(i)) continue;
            return true;
        }
        return false;
    }

    public Tag getTagByNumber(int i) {
        if (this.tags != null && !this.tags.isEmpty()) {
            for (Tag t : this.tags) {
                if (!t.isNumber(i)) continue;
                return t;
            }
        }
        return null;
    }

    public Field getFieldByNumber(int num) {
        Tag t = this.getTagByNumber(num);
        if (t != null) {
            return t.getField();
        }
        return null;
    }

    public List<Tag> getTagsByNumber(int i) {
        if (this.tags == null || this.tags.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Tag> result = new ArrayList<Tag>();
        for (Tag t : this.tags) {
            if (!t.isNumber(i)) continue;
            result.add(t);
        }
        return result;
    }

    public List<? extends Field> getFieldsByNumber(int i) {
        if (this.tags == null || this.tags.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Field> result = new ArrayList<Field>();
        for (Tag t : this.tags) {
            if (!t.isNumber(i)) continue;
            Field f = t.getField();
            if (f == null) {
                throw new IllegalArgumentException("Unable to create field for tagname " + t.getName());
            }
            result.add(f);
        }
        return result;
    }

    public Field getFieldByNumber(int number, String being) {
        if (this.tags == null || this.tags.isEmpty()) {
            return null;
        }
        for (Tag t : this.tags) {
            if (!t.isNumber(number)) continue;
            Field f = t.getField();
            if (f == null) {
                throw new IllegalArgumentException("Unable to create field for tagname " + t.getName());
            }
            if (!f.is(being)) continue;
            return f;
        }
        return null;
    }

    public List<Tag> getTagsByValue(String value) {
        ArrayList<Tag> result = new ArrayList<Tag>();
        for (int i = 0; i < this.tags.size(); ++i) {
            Tag t = this.tags.get(i);
            if (!StringUtils.equals((String)value, (String)t.getValue())) continue;
            result.add(t);
        }
        return result;
    }

    public List<Tag> getTagsByContent(String value) {
        ArrayList<Tag> result = new ArrayList<Tag>();
        for (int i = 0; i < this.tags.size(); ++i) {
            Tag t = this.tags.get(i);
            if (!StringUtils.contains((String)t.getValue(), (String)value)) continue;
            result.add(t);
        }
        return result;
    }

    public List<SwiftTagListBlock> getSubBlocks(Tag start, Tag end) {
        ArrayList<SwiftTagListBlock> result = new ArrayList<SwiftTagListBlock>();
        SwiftTagListBlock toAdd = null;
        boolean blockFound = false;
        for (int i = 0; i < this.tags.size(); ++i) {
            Tag t = this.tags.get(i);
            if (blockFound) {
                toAdd.append(t);
                if (end == null || !end.equals(t)) continue;
                result.add(toAdd);
                blockFound = false;
                toAdd = null;
                continue;
            }
            if (!start.equals(t)) continue;
            toAdd = new SwiftTagListBlock();
            toAdd.append(t);
            blockFound = true;
        }
        if (toAdd != null) {
            result.add(toAdd);
        }
        return result;
    }

    public SwiftTagListBlock getSubBlock(Tag start, Tag end) {
        List<SwiftTagListBlock> l = this.getSubBlocks(start, end);
        if (l.isEmpty()) {
            return new SwiftTagListBlock();
        }
        return l.get(0);
    }

    public List<SwiftTagListBlock> getSubBlocks(String startTagName, String endTagName) {
        Tag start = new Tag(startTagName, "");
        Tag end = new Tag(endTagName, "");
        return this._getSubBlocks(start.getNumber(), start.getLetterOption(), end.getNumber(), end.getLetterOption());
    }

    public List<SwiftTagListBlock> getSubBlocks(int startTagNumber, int endTagNumber) {
        return this._getSubBlocks(startTagNumber, null, endTagNumber, null);
    }

    public List<SwiftTagListBlock> getSubBlocks(String startTagName, int endTagNumber) {
        Tag start = new Tag(startTagName, "");
        return this._getSubBlocks(start.getNumber(), start.getLetterOption(), endTagNumber, null);
    }

    public List<SwiftTagListBlock> getSubBlocks(int startTagNumber, String endTagName) {
        Tag end = new Tag(endTagName, "");
        return this._getSubBlocks(startTagNumber, null, end.getNumber(), end.getLetterOption());
    }

    private List<SwiftTagListBlock> _getSubBlocks(int startTagNumber, String startTagLetter, int endTagNumber, String endTagLetter) {
        ArrayList<SwiftTagListBlock> result = new ArrayList<SwiftTagListBlock>();
        SwiftTagListBlock toAdd = null;
        boolean blockFound = false;
        for (int i = 0; i < this.tags.size(); ++i) {
            Tag t = this.tags.get(i);
            if (blockFound) {
                toAdd.append(t);
                if ((endTagLetter == null || !StringUtils.equals((String)t.getName(), (String)(endTagNumber + endTagLetter))) && (endTagLetter != null || !t.isNumber(endTagNumber))) continue;
                result.add(toAdd);
                blockFound = false;
                toAdd = null;
                continue;
            }
            if ((startTagLetter == null || !StringUtils.equals((String)t.getName(), (String)(startTagNumber + startTagLetter))) && (startTagLetter != null || !t.isNumber(startTagNumber))) continue;
            toAdd = new SwiftTagListBlock();
            toAdd.append(t);
            blockFound = true;
        }
        if (toAdd != null) {
            result.add(toAdd);
        }
        return result;
    }

    public SwiftTagListBlock getSubBlockByIndex(Integer startIndex, Integer endIndex) {
        return new SwiftTagListBlock(this.tags.subList(startIndex == null ? 0 : startIndex, endIndex == null ? this.tags.size() : endIndex.intValue()));
    }

    public Integer getTagIndex(String startTagNumber, String[] letterOptions) {
        for (int i = 0; i < this.tags.size(); ++i) {
            Tag t = this.tags.get(i);
            if (!StringUtils.startsWith((String)t.getName(), (String)startTagNumber)) continue;
            if (letterOptions == null || letterOptions.length < 1) {
                return i;
            }
            for (String l : letterOptions) {
                if (!StringUtils.equals((String)t.getName(), (String)(startTagNumber + l))) continue;
                return i;
            }
        }
        return null;
    }

    public SwiftTagListBlock getSubBlock(String startTagName, String endTagName) {
        List<SwiftTagListBlock> l = this.getSubBlocks(startTagName, endTagName);
        if (l.isEmpty()) {
            return new SwiftTagListBlock();
        }
        return l.get(0);
    }

    public List<SwiftTagListBlock> getSubBlocks(String blockName) {
        return this.getSubBlocks(new Tag("16R", blockName), new Tag("16S", blockName));
    }

    public SwiftTagListBlock getSubBlock(String blockName) {
        return this.getSubBlock(new Tag("16R", blockName), new Tag("16S", blockName));
    }

    public boolean containsTag(Tag t) {
        if (this.tags == null || this.tags.isEmpty()) {
            return false;
        }
        Iterator<Tag> it = this.tags.iterator();
        while (it.hasNext()) {
            if (!t.equals(it.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public Integer getNumber() {
        return null;
    }

    @Override
    protected void setBlockName(String blockName) {
    }

    @Override
    protected void setBlockNumber(Integer blockNumber) {
    }

    public void visit(TagVisitor visitor) {
        if (visitor != null && this.tags != null && !this.tags.isEmpty()) {
            for (Tag t : this.tags) {
                visitor.onTag(t);
            }
        }
    }

    public List<SwiftTagListBlock> splitByTagName(String tagName) {
        ArrayList<SwiftTagListBlock> result = new ArrayList<SwiftTagListBlock>();
        if (this.tags.isEmpty() || !this.containsTag(tagName)) {
            result.add(this);
        } else {
            SwiftTagListBlock b = new SwiftTagListBlock();
            b.append(this.tags.get(0));
            for (int i = 1; i < this.tags.size(); ++i) {
                Tag t = this.tags.get(i);
                if (StringUtils.equals((String)tagName, (String)t.getName())) {
                    result.add(b);
                    b = new SwiftTagListBlock();
                }
                b.append(t);
            }
            if (!result.contains(b)) {
                result.add(b);
            }
        }
        return result;
    }

    public boolean containsField(String name) {
        Field[] arr = this.getFieldsByName(name);
        return arr != null && arr.length > 0;
    }

    public SwiftTagListBlock getSubBlockAfterFirst(String tagname, boolean includeSeparator) {
        SwiftTagListBlock result = new SwiftTagListBlock();
        if (this.tags != null && !this.tags.isEmpty()) {
            boolean toggleAdd = false;
            for (int i = 0; i < this.tags.size(); ++i) {
                boolean isSeparator = false;
                Tag t = this.tags.get(i);
                if (StringUtils.equals((String)tagname, (String)t.getName())) {
                    toggleAdd = true;
                    isSeparator = true;
                }
                if ((!toggleAdd || isSeparator) && (!isSeparator || !includeSeparator)) continue;
                result.append(t);
            }
        }
        return result;
    }

    @Deprecated
    public SwiftTagListBlock getSubBlockAfterFirst(String tagname) {
        return this.getSubBlockAfterFirst(tagname, true);
    }

    public SwiftTagListBlock getSubBlockBeforeFirst(String tagname, boolean includeSeparator) {
        SwiftTagListBlock result = new SwiftTagListBlock();
        if (this.tags != null && !this.tags.isEmpty()) {
            Iterator<Tag> it = this.tags.iterator();
            boolean done = false;
            while (it.hasNext() && !done) {
                Tag t = it.next();
                if (StringUtils.equals((String)tagname, (String)t.getName())) {
                    if (includeSeparator) {
                        result.append(t);
                    }
                    done = true;
                    continue;
                }
                result.append(t);
            }
        }
        return result;
    }

    public SwiftTagListBlock getSubBlockAfterLast(String tagname, boolean includeDelimiterInResult) {
        int i = this.indexOfLast(tagname);
        if (i >= 0) {
            if (includeDelimiterInResult) {
                return this.getSubBlock(i, null);
            }
            if (i < this.tags.size()) {
                return this.getSubBlock(i + 1, null);
            }
        }
        return null;
    }

    public SwiftTagListBlock getSubBlock(Integer from, Integer to) {
        int t;
        int f = from == null ? 0 : from;
        int n = t = to == null || to > this.tags.size() - 1 ? this.tags.size() : to.intValue();
        if (f >= t) {
            throw new IllegalArgumentException("from (" + f + ") is equal or bigger than to (" + t + ")");
        }
        SwiftTagListBlock result = new SwiftTagListBlock();
        result.addTags(this.tags.subList(f, t));
        return result;
    }

    public int indexOfLast(String tagname) {
        int result = -1;
        if (this.tags != null && !this.tags.isEmpty()) {
            for (int i = 0; i < this.tags.size(); ++i) {
                if (!StringUtils.equals((String)tagname, (String)this.tags.get(i).getName())) continue;
                result = i;
            }
        }
        return result;
    }

    public int indexOfLastValue(String tagname, String value) {
        int result = -1;
        if (this.tags != null && !this.tags.isEmpty()) {
            for (int i = 0; i < this.tags.size(); ++i) {
                if (!StringUtils.equals((String)tagname, (String)this.tags.get(i).getName()) || !StringUtils.equals((String)value, (String)this.tags.get(i).getValue())) continue;
                result = i;
            }
        }
        return result;
    }

    public int indexOfAnyLast(String ... tagnames) {
        int result = -1;
        if (this.tags != null && !this.tags.isEmpty()) {
            for (int i = 0; i < this.tags.size(); ++i) {
                for (String tn : tagnames) {
                    if (!StringUtils.equals((String)tn, (String)this.tags.get(i).getName())) continue;
                    result = i;
                }
            }
        }
        return result;
    }

    public int indexOfAnyLastAfterIndex(int index, String ... tagnames) {
        int result = -1;
        if (this.tags != null && !this.tags.isEmpty()) {
            for (int i = index; i < this.tags.size(); ++i) {
                for (String tn : tagnames) {
                    if (!StringUtils.equals((String)tn, (String)this.tags.get(i).getName())) continue;
                    result = i;
                }
            }
        }
        return result;
    }

    public int indexOfFirst(String tagname) {
        if (this.tags != null && !this.tags.isEmpty()) {
            for (int i = 0; i < this.tags.size(); ++i) {
                if (!StringUtils.equals((String)tagname, (String)this.tags.get(i).getName())) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOfFirstValue(String tagname, String value) {
        if (this.tags != null && !this.tags.isEmpty()) {
            for (int i = 0; i < this.tags.size(); ++i) {
                if (!StringUtils.equals((String)tagname, (String)this.tags.get(i).getName()) || !StringUtils.equals((String)value, (String)this.tags.get(i).getValue())) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOfAnyFirst(String ... tagnames) {
        if (this.tags != null && !this.tags.isEmpty()) {
            for (int i = 0; i < this.tags.size(); ++i) {
                for (String tn : tagnames) {
                    if (!StringUtils.equals((String)tn, (String)this.tags.get(i).getName())) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    public int indexOfAnyFirstAfterIndex(int index, String ... tagnames) {
        if (this.tags != null && !this.tags.isEmpty()) {
            for (int i = index; i < this.tags.size(); ++i) {
                for (String tn : tagnames) {
                    if (!StringUtils.equals((String)tn, (String)this.tags.get(i).getName())) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    public SwiftTagListBlock getSubBlockBeforeLast(String tagname, boolean includeDelimiterInResult) {
        int i = this.indexOfLast(tagname);
        if (includeDelimiterInResult && i > 0) {
            return this.getSubBlock(null, i + 1);
        }
        if (!includeDelimiterInResult && i > 0) {
            return this.getSubBlock(null, i);
        }
        return null;
    }

    public SwiftTagListBlock trimAfterFirst(String tagname, boolean includeBoundaryInResult) {
        SwiftTagListBlock result = new SwiftTagListBlock();
        boolean boundaryFound = false;
        for (int i = 0; i < this.tags.size(); ++i) {
            boolean currentTagIsBoundary;
            Tag t = this.tags.get(i);
            if (StringUtils.equals((String)tagname, (String)t.getName())) {
                boundaryFound = true;
                currentTagIsBoundary = true;
            } else {
                currentTagIsBoundary = false;
            }
            if (boundaryFound && (!currentTagIsBoundary || !includeBoundaryInResult)) continue;
            result.append(t);
        }
        return result;
    }

    public SwiftTagListBlock removeUntilFirst(String tagname, boolean includeBoundaryInResult) {
        SwiftTagListBlock result = new SwiftTagListBlock();
        boolean boundaryFound = false;
        for (int i = 0; i < this.tags.size(); ++i) {
            Tag t = this.tags.get(i);
            if (boundaryFound) {
                result.append(t);
                continue;
            }
            if (!StringUtils.equals((String)tagname, (String)t.getName())) continue;
            boundaryFound = true;
            if (!includeBoundaryInResult) continue;
            result.append(t);
        }
        return result;
    }

    public SwiftTagListBlock removeSubBlock(String blockName) {
        SwiftTagListBlock result = new SwiftTagListBlock();
        boolean startBoundaryFound = false;
        boolean endBoundaryFound = false;
        for (int i = 0; i < this.tags.size(); ++i) {
            boolean isEndBoundaryFound = false;
            Tag t = this.tags.get(i);
            if (StringUtils.equals((String)blockName, (String)t.getValue())) {
                if (StringUtils.equals((String)"16R", (String)t.getName())) {
                    startBoundaryFound = true;
                } else if (StringUtils.equals((String)"16S", (String)t.getName())) {
                    endBoundaryFound = true;
                    isEndBoundaryFound = true;
                }
            }
            if (startBoundaryFound && (!endBoundaryFound || isEndBoundaryFound)) continue;
            result.append(t);
        }
        return result;
    }

    public boolean containsAnyOf(String ... name) {
        if (name != null && name.length > 0) {
            for (String s : name) {
                if (!this.containsTag(s)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsAllOf(String ... name) {
        if (name != null && name.length > 0) {
            for (String s : name) {
                if (this.containsTag(s)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public SwiftTagListBlock filterByName(boolean include, String ... names) {
        SwiftTagListBlock result = new SwiftTagListBlock();
        if (names.length == 0) {
            if (!include) {
                result.setTags(this.getTags());
            }
        } else {
            Object[] tagnames = names;
            for (int i = 0; i < this.tags.size(); ++i) {
                Tag t = this.tags.get(i);
                boolean matched = false;
                for (int j = 0; !matched && j < tagnames.length; ++j) {
                    if (!StringUtils.equals((String)t.getName(), (String)tagnames[j])) continue;
                    matched = true;
                    tagnames = (String[])ArrayUtils.remove((Object[])tagnames, (int)j);
                }
                if (matched && include) {
                    result.append(t);
                }
                if (matched || include) continue;
                result.append(t);
            }
        }
        return result;
    }

    public SwiftTagListBlock filterByNameOrdered(String ... names) {
        Object[] tagnames = names;
        SwiftTagListBlock result = new SwiftTagListBlock();
        for (Tag t : this.getTags()) {
            boolean matched = false;
            for (int j = 0; !matched && j < tagnames.length; ++j) {
                if (!StringUtils.equals((String)t.getName(), (String)tagnames[j])) continue;
                matched = true;
                tagnames = (String[])ArrayUtils.remove((Object[])tagnames, (int)j);
                result.append(t);
            }
            if (matched) continue;
            break;
        }
        return result;
    }

    public SwiftTagListBlock removeAfterFirst(String name, boolean includeBoundaryInResult) {
        SwiftTagListBlock result = new SwiftTagListBlock();
        if (this.tags != null && !this.tags.isEmpty()) {
            for (int i = 0; i < this.tags.size(); ++i) {
                Tag tag = this.tags.get(i);
                if (StringUtils.equals((String)name, (String)tag.getName())) {
                    if (includeBoundaryInResult) {
                        result.append(tag);
                    }
                    return result;
                }
                result.append(tag);
            }
        }
        return result;
    }

    public List<SwiftTagListBlock> getSubBlocksDelimitedWithOptionalTail(String[] start, String[] end, String[] tail) {
        if (this.tags != null && !this.tags.isEmpty()) {
            ArrayList<SwiftTagListBlock> result = new ArrayList<SwiftTagListBlock>();
            int offset = 0;
            boolean done = false;
            while (!done) {
                int e;
                int s = this.indexOfAnyFirstAfterIndex(offset, start);
                offset = e = this.indexOfAnyFirstAfterIndex(s + 1, end);
                if (s == -1 || e == -1) {
                    done = true;
                    continue;
                }
                if (e < s) continue;
                SwiftTagListBlock l = this.sublist(s, e);
                if (tail != null && tail.length > 0) {
                    boolean abort = false;
                    for (int i = e + 1; i < this.tags.size() && !abort; ++i) {
                        boolean added = false;
                        for (String tn : tail) {
                            Tag tag = this.tags.get(i);
                            if (!StringUtils.equals((String)tag.getName(), (String)tn)) continue;
                            l.append(tag);
                            ++offset;
                            added = true;
                        }
                        if (added) continue;
                        abort = true;
                    }
                }
                result.add(l);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public List<SwiftTagListBlock> getSubBlocksByTagNames(Integer startIndex, String ... searchTags) {
        SwiftTagListBlock found;
        int start;
        ArrayList<SwiftTagListBlock> result = new ArrayList<SwiftTagListBlock>();
        int n = start = startIndex != null ? startIndex : 0;
        while (start < this.tags.size() && !(found = this.getSubBlockByTagNames(start, searchTags)).isEmpty()) {
            result.add(found);
            Tag last = found.getTag(found.size() - 1);
            int index = this.tags.indexOf(last);
            start = index + 1;
        }
        return result;
    }

    public SwiftTagListBlock getSubBlockByTagNames(Integer startIndex, String ... searchTags) {
        int searchIndex = 0;
        SwiftTagListBlock found = new SwiftTagListBlock();
        for (int tagsIndex = startIndex != null ? startIndex : 0; tagsIndex < this.tags.size() && searchIndex < searchTags.length; ++tagsIndex) {
            Tag candidate = this.tags.get(tagsIndex);
            for (int j = searchIndex; j < searchTags.length; ++j) {
                if (!candidate.getName().equals(searchTags[j])) continue;
                found.append(candidate);
                searchIndex = j;
                break;
            }
            if (searchIndex != searchTags.length) continue;
            if (!found.isEmpty()) {
                return found;
            }
            searchIndex = 0;
        }
        return found;
    }

    public SwiftTagListBlock getSubBlockDelimitedWithOptionalTail(String[] start, String[] end, String[] tail) {
        if (this.tags != null && !this.tags.isEmpty()) {
            int s = this.indexOfAnyFirst(start);
            int e = this.indexOfAnyFirstAfterIndex(s + 1, end);
            if (s != -1 && e != -1 && e >= s) {
                SwiftTagListBlock result = this.sublist(s, e);
                if (tail == null || tail.length == 0) {
                    return result;
                }
                boolean abort = false;
                for (int i = e + 1; i < this.tags.size() && !abort; ++i) {
                    boolean added = false;
                    for (String tn : tail) {
                        if (!StringUtils.equals((String)this.tags.get(i).getName(), (String)tn)) continue;
                        result.append(this.tags.get(i));
                        added = true;
                    }
                    if (added) continue;
                    abort = true;
                }
                return result;
            }
        }
        return null;
    }

    public SwiftTagListBlock sublist(Integer start, Integer end) {
        if (this.tags == null || this.tags.isEmpty()) {
            throw new IllegalStateException("No tags in this list");
        }
        if (start != null && start < 0 || end != null && end + 1 > this.tags.size() || start != null && end != null && start > end) {
            throw new IllegalArgumentException("start: " + start + ", end: " + end + ", size=" + this.tags.size());
        }
        SwiftTagListBlock result = new SwiftTagListBlock();
        int s = start == null ? 0 : start;
        int e = end == null ? this.tags.size() - 1 : end;
        for (int i = s; i <= e; ++i) {
            result.append(this.tags.get(i));
        }
        return result;
    }

    public SwiftTagListBlock getOptionalList(String[][] optionalTags) {
        return this.getOptionalList(optionalTags, 0);
    }

    public SwiftTagListBlock getOptionalList(String[][] optionalTags, int startAt) {
        if (this.tags != null && !this.tags.isEmpty()) {
            SwiftTagListBlock result = new SwiftTagListBlock();
            boolean done = false;
            int t = startAt;
            int rowPointer = 0;
            do {
                Tag tag;
                int rowIndex;
                if ((rowIndex = this.findTagInRowSince(tag = this.tags.get(t++), rowPointer, optionalTags)) >= 0) {
                    rowPointer = rowIndex + 1;
                    result.append(tag);
                    continue;
                }
                done = true;
            } while (!done);
            return result;
        }
        return null;
    }

    private int findTagInRowSince(Tag tag, int rowPointer, String[][] optionalTags) {
        for (int r = rowPointer; r < optionalTags.length; ++r) {
            String[] row = optionalTags[r];
            for (int i = 0; i < row.length; ++i) {
                String op = row[i];
                if (!StringUtils.equals((String)tag.getName(), (String)op)) continue;
                return r;
            }
        }
        return -1;
    }

    public List<SwiftTagListBlock> getOptionalLists(String[][] optionalTags) {
        ArrayList<SwiftTagListBlock> result = new ArrayList<SwiftTagListBlock>();
        if (this.tags != null && !this.tags.isEmpty()) {
            boolean done = false;
            int offset = 0;
            while (!done) {
                SwiftTagListBlock o;
                if ((offset += (o = this.getOptionalList(optionalTags, offset)).size()) > this.tags.size() || o.isEmpty()) {
                    done = true;
                }
                if (o.isEmpty()) continue;
                result.add(o);
            }
        }
        return result;
    }

    public List<String> tagNamesList() {
        if (this.tags == null || this.tags.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Tag t : this.tags) {
            result.add(t.getName());
        }
        return result;
    }

    public int countTagsStarsWith(String name, String value) {
        int result = 0;
        if (this.tags != null && !this.tags.isEmpty()) {
            for (Tag t : this.tags) {
                if (!StringUtils.equals((String)name, (String)t.getName()) || !t.startsWith(value)) continue;
                ++result;
            }
        }
        return result;
    }

    public SwiftTagListBlock removeAfterFirstStartsWith(String name, String startsWith) {
        if (this.tags == null || !this.tags.isEmpty()) {
            return new SwiftTagListBlock();
        }
        ArrayList<Tag> tags = new ArrayList<Tag>();
        boolean done = false;
        for (int i = 0; i < this.tags.size() && !done; ++i) {
            Tag t = this.tags.get(i);
            if (StringUtils.equals((String)t.getName(), (String)name) && t.startsWith(startsWith)) {
                done = true;
                continue;
            }
            tags.add(t);
        }
        return new SwiftTagListBlock(tags);
    }

    public String toJson() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ \n");
        if (this.tags != null && !this.tags.isEmpty()) {
            for (int i = 0; i < this.tags.size(); ++i) {
                Tag t = this.tags.get(i);
                sb.append("{ \"").append(t.getName()).append("\" : \"").append(this.escapeJson(t.getValue())).append("\" }");
                if (i + 1 < this.tags.size()) {
                    sb.append(',');
                }
                sb.append('\n');
            }
        }
        sb.append("]");
        return sb.toString();
    }

    private String escapeJson(String value) {
        String tmp = StringUtils.replace((String)value, (String)"\n", (String)"\\n");
        tmp = StringUtils.replace((String)tmp, (String)"\"", (String)"\\\"");
        tmp = StringUtils.remove((String)tmp, (String)"\r");
        return tmp;
    }

    public SwiftTagListBlock append(SwiftTagListBlock block) {
        if (block != null && !block.isEmpty()) {
            this.tags.addAll(block.getTags());
        }
        return this;
    }

    public SwiftTagListBlock append(SwiftTagListBlock ... blocks) {
        if (blocks != null && blocks.length > 0) {
            for (SwiftTagListBlock b : blocks) {
                this.tags.addAll(b.getTags());
            }
        }
        return this;
    }

    public SwiftTagListBlock append(Tag tag) {
        Validate.notNull((Object)tag);
        this.tags.add(tag);
        return this;
    }

    public SwiftTagListBlock append(Tag ... tags) {
        if (tags != null && tags.length > 0) {
            for (Tag t : tags) {
                this.tags.add(t);
            }
        }
        return this;
    }

    public SwiftTagListBlock append(Field field) {
        Validate.notNull((Object)field);
        this.tags.add(field.asTag());
        return this;
    }

    public SwiftTagListBlock append(Field ... fields) {
        if (fields != null && fields.length > 0) {
            for (Field f : fields) {
                this.append(f);
            }
        }
        return this;
    }

    @Override
    public Iterator<Tag> iterator() {
        if (this.tags == null) {
            Collections.emptyList().iterator();
        }
        return this.tags.iterator();
    }

    public Tag[] asTagArray() {
        if (this.size() > 0) {
            Tag[] result = new Tag[this.size()];
            int i = 0;
            for (Tag t : this.tags) {
                result[i++] = t;
            }
            return result;
        }
        return new Tag[0];
    }

    public SwiftTagListBlock clear() {
        if (this.tags != null) {
            this.tags.clear();
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EmptyItr
    implements Iterator<Tag> {
        private EmptyItr() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Tag next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Can't remove on an empty iterator");
        }
    }
}

